/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexing;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ParseField;

public enum IndexerState implements Writeable
{
    STARTED,
    INDEXING,
    STOPPING,
    STOPPED,
    ABORTING;

    public final ParseField STATE = new ParseField("job_state", new String[0]);

    public static IndexerState fromString(String name) {
        return IndexerState.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static IndexerState fromStream(StreamInput in) throws IOException {
        return in.readEnum(IndexerState.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        IndexerState state = this;
        out.writeEnum(state);
    }

    public String value() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

