/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedUpdate;

public class UpdateDatafeedAction
extends ActionType<PutDatafeedAction.Response> {
    public static final UpdateDatafeedAction INSTANCE = new UpdateDatafeedAction();
    public static final String NAME = "cluster:admin/xpack/ml/datafeeds/update";

    private UpdateDatafeedAction() {
        super(NAME, PutDatafeedAction.Response::new);
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, PutDatafeedAction.Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, UpdateDatafeedAction action) {
            super(client, action, new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        private DatafeedUpdate update;

        public static Request parseRequest(String datafeedId, @Nullable IndicesOptions indicesOptions, XContentParser parser) {
            DatafeedUpdate.Builder update = DatafeedUpdate.PARSER.apply(parser, null);
            if (indicesOptions != null) {
                update.setIndicesOptions(indicesOptions);
            }
            update.setId(datafeedId);
            return new Request(update.build());
        }

        public Request(DatafeedUpdate update) {
            this.update = update;
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.update = new DatafeedUpdate(in);
        }

        public DatafeedUpdate getUpdate() {
            return this.update;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.update.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.update.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.update, request.update);
        }

        public int hashCode() {
            return Objects.hash(this.update);
        }
    }
}

