/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsDest;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsSource;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.DataFrameAnalysis;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DataFrameAnalyticsConfig
implements ToXContentObject,
Writeable {
    public static final String BLANK_ID = "blank_data_frame_id";
    public static final String BLANK_DEST_INDEX = "blank_dest_index";
    public static final String TYPE = "data_frame_analytics_config";
    public static final ByteSizeValue DEFAULT_MODEL_MEMORY_LIMIT = ByteSizeValue.ofGb(1L);
    public static final ByteSizeValue MIN_MODEL_MEMORY_LIMIT = ByteSizeValue.ofKb(1L);
    public static final ByteSizeValue PROCESS_MEMORY_OVERHEAD = ByteSizeValue.ofMb(5L);
    public static final ParseField ID = new ParseField("id", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField SOURCE = new ParseField("source", new String[0]);
    public static final ParseField DEST = new ParseField("dest", new String[0]);
    public static final ParseField ANALYSIS = new ParseField("analysis", new String[0]);
    public static final ParseField CONFIG_TYPE = new ParseField("config_type", new String[0]);
    public static final ParseField ANALYZED_FIELDS = new ParseField("analyzed_fields", new String[0]);
    public static final ParseField MODEL_MEMORY_LIMIT = new ParseField("model_memory_limit", new String[0]);
    public static final ParseField HEADERS = new ParseField("headers", new String[0]);
    public static final ParseField CREATE_TIME = new ParseField("create_time", new String[0]);
    public static final ParseField VERSION = new ParseField("version", new String[0]);
    public static final ParseField ALLOW_LAZY_START = new ParseField("allow_lazy_start", new String[0]);
    public static final ParseField MAX_NUM_THREADS = new ParseField("max_num_threads", new String[0]);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = DataFrameAnalyticsConfig.createParser(false);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = DataFrameAnalyticsConfig.createParser(true);
    private final String id;
    private final String description;
    private final DataFrameAnalyticsSource source;
    private final DataFrameAnalyticsDest dest;
    private final DataFrameAnalysis analysis;
    private final FetchSourceContext analyzedFields;
    private final ByteSizeValue modelMemoryLimit;
    private final Map<String, String> headers;
    private final Instant createTime;
    private final Version version;
    private final boolean allowLazyStart;
    private final int maxNumThreads;

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser<Builder, Void> parser = new ObjectParser<Builder, Void>(TYPE, ignoreUnknownFields, Builder::new);
        parser.declareString((c, s) -> {}, CONFIG_TYPE);
        parser.declareString(Builder::setId, ID);
        parser.declareString(Builder::setDescription, DESCRIPTION);
        parser.declareObject(Builder::setSource, DataFrameAnalyticsSource.createParser(ignoreUnknownFields), SOURCE);
        parser.declareObject(Builder::setDest, DataFrameAnalyticsDest.createParser(ignoreUnknownFields), DEST);
        parser.declareObject(Builder::setAnalysis, (p, c) -> DataFrameAnalyticsConfig.parseAnalysis(p, ignoreUnknownFields), ANALYSIS);
        parser.declareField(Builder::setAnalyzedFields, (p, c) -> FetchSourceContext.fromXContent(p), ANALYZED_FIELDS, ObjectParser.ValueType.OBJECT_ARRAY_BOOLEAN_OR_STRING);
        parser.declareField(Builder::setModelMemoryLimit, (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), MODEL_MEMORY_LIMIT.getPreferredName()), MODEL_MEMORY_LIMIT, ObjectParser.ValueType.VALUE);
        parser.declareBoolean(Builder::setAllowLazyStart, ALLOW_LAZY_START);
        parser.declareInt(Builder::setMaxNumThreads, MAX_NUM_THREADS);
        if (ignoreUnknownFields) {
            parser.declareObject(Builder::setHeaders, (p, c) -> p.mapStrings(), HEADERS);
            parser.declareField(Builder::setCreateTime, p -> TimeUtils.parseTimeFieldToInstant(p, CREATE_TIME.getPreferredName()), CREATE_TIME, ObjectParser.ValueType.VALUE);
            parser.declareString(Builder::setVersion, Version::fromString, VERSION);
        }
        return parser;
    }

    private static DataFrameAnalysis parseAnalysis(XContentParser parser, boolean ignoreUnknownFields) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser);
        DataFrameAnalysis analysis = parser.namedObject(DataFrameAnalysis.class, parser.currentName(), ignoreUnknownFields);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
        return analysis;
    }

    private DataFrameAnalyticsConfig(String id, String description, DataFrameAnalyticsSource source, DataFrameAnalyticsDest dest, DataFrameAnalysis analysis, Map<String, String> headers, ByteSizeValue modelMemoryLimit, FetchSourceContext analyzedFields, Instant createTime, Version version, boolean allowLazyStart, Integer maxNumThreads) {
        this.id = ExceptionsHelper.requireNonNull(id, ID);
        this.description = description;
        this.source = ExceptionsHelper.requireNonNull(source, SOURCE);
        this.dest = ExceptionsHelper.requireNonNull(dest, DEST);
        this.analysis = ExceptionsHelper.requireNonNull(analysis, ANALYSIS);
        this.analyzedFields = analyzedFields;
        this.modelMemoryLimit = modelMemoryLimit;
        this.headers = Collections.unmodifiableMap(headers);
        this.createTime = createTime == null ? null : Instant.ofEpochMilli(createTime.toEpochMilli());
        this.version = version;
        this.allowLazyStart = allowLazyStart;
        if (maxNumThreads != null && maxNumThreads < 1) {
            throw ExceptionsHelper.badRequestException("[{}] must be a positive integer", MAX_NUM_THREADS.getPreferredName());
        }
        this.maxNumThreads = maxNumThreads == null ? 1 : maxNumThreads;
    }

    public DataFrameAnalyticsConfig(StreamInput in) throws IOException {
        this.id = in.readString();
        this.description = in.getVersion().onOrAfter(Version.V_7_4_0) ? in.readOptionalString() : null;
        this.source = new DataFrameAnalyticsSource(in);
        this.dest = new DataFrameAnalyticsDest(in);
        this.analysis = in.readNamedWriteable(DataFrameAnalysis.class);
        this.analyzedFields = in.readOptionalWriteable(FetchSourceContext::new);
        this.modelMemoryLimit = in.readOptionalWriteable(ByteSizeValue::new);
        this.headers = Collections.unmodifiableMap(in.readMap(StreamInput::readString, StreamInput::readString));
        if (in.getVersion().onOrAfter(Version.V_7_3_0)) {
            this.createTime = in.readOptionalInstant();
            this.version = in.readBoolean() ? Version.readVersion(in) : null;
        } else {
            this.createTime = null;
            this.version = null;
        }
        this.allowLazyStart = in.getVersion().onOrAfter(Version.V_7_5_0) ? in.readBoolean() : false;
        this.maxNumThreads = in.getVersion().onOrAfter(Version.V_7_9_0) ? in.readVInt() : 1;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public DataFrameAnalyticsSource getSource() {
        return this.source;
    }

    public DataFrameAnalyticsDest getDest() {
        return this.dest;
    }

    public DataFrameAnalysis getAnalysis() {
        return this.analysis;
    }

    public FetchSourceContext getAnalyzedFields() {
        return this.analyzedFields;
    }

    public ByteSizeValue getModelMemoryLimit() {
        return this.modelMemoryLimit != null ? this.modelMemoryLimit : DEFAULT_MODEL_MEMORY_LIMIT;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isAllowLazyStart() {
        return this.allowLazyStart;
    }

    public Integer getMaxNumThreads() {
        return this.maxNumThreads;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.id);
        if (!params.paramAsBoolean("exclude_generated", false)) {
            if (this.createTime != null) {
                builder.timeField(CREATE_TIME.getPreferredName(), CREATE_TIME.getPreferredName() + "_string", this.createTime.toEpochMilli());
            }
            if (this.version != null) {
                builder.field(VERSION.getPreferredName(), this.version);
            }
            if (!this.headers.isEmpty() && params.paramAsBoolean("for_internal_storage", false)) {
                ClientHelper.assertNoAuthorizationHeader(this.headers);
                builder.field(HEADERS.getPreferredName(), this.headers);
            }
            if (params.paramAsBoolean("for_internal_storage", false)) {
                builder.field(CONFIG_TYPE.getPreferredName(), TYPE);
            }
        }
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        builder.field(SOURCE.getPreferredName(), this.source);
        builder.field(DEST.getPreferredName(), this.dest);
        builder.startObject(ANALYSIS.getPreferredName());
        builder.field(this.analysis.getWriteableName(), this.analysis, new ToXContent.MapParams(Collections.singletonMap(VERSION.getPreferredName(), this.version == null ? null : this.version.toString())));
        builder.endObject();
        if (this.analyzedFields != null) {
            builder.field(ANALYZED_FIELDS.getPreferredName(), this.analyzedFields);
        }
        builder.field(MODEL_MEMORY_LIMIT.getPreferredName(), this.getModelMemoryLimit().getStringRep());
        builder.field(ALLOW_LAZY_START.getPreferredName(), this.allowLazyStart);
        builder.field(MAX_NUM_THREADS.getPreferredName(), this.maxNumThreads);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeOptionalString(this.description);
        }
        this.source.writeTo(out);
        this.dest.writeTo(out);
        out.writeNamedWriteable(this.analysis);
        out.writeOptionalWriteable(this.analyzedFields);
        out.writeOptionalWriteable(this.modelMemoryLimit);
        out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            out.writeOptionalInstant(this.createTime);
            if (this.version != null) {
                out.writeBoolean(true);
                Version.writeVersion(this.version, out);
            } else {
                out.writeBoolean(false);
            }
        }
        if (out.getVersion().onOrAfter(Version.V_7_5_0)) {
            out.writeBoolean(this.allowLazyStart);
        }
        if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
            out.writeVInt(this.maxNumThreads);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFrameAnalyticsConfig other = (DataFrameAnalyticsConfig)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.description, other.description) && Objects.equals(this.source, other.source) && Objects.equals(this.dest, other.dest) && Objects.equals(this.analysis, other.analysis) && Objects.equals(this.headers, other.headers) && Objects.equals(this.getModelMemoryLimit(), other.getModelMemoryLimit()) && Objects.equals(this.analyzedFields, other.analyzedFields) && Objects.equals(this.createTime, other.createTime) && Objects.equals(this.version, other.version) && Objects.equals(this.allowLazyStart, other.allowLazyStart) && this.maxNumThreads == other.maxNumThreads;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.description, this.source, this.dest, this.analysis, this.headers, this.getModelMemoryLimit(), this.analyzedFields, this.createTime, this.version, this.allowLazyStart, this.maxNumThreads);
    }

    public String toString() {
        return Strings.toString(this);
    }

    public static String documentId(String id) {
        return "data_frame_analytics_config-" + id;
    }

    @Nullable
    public static String extractJobIdFromDocId(String docId) {
        String jobId = docId.replaceAll("^data_frame_analytics_config-", "");
        return jobId.equals(docId) ? null : jobId;
    }

    public static class Builder {
        private String id;
        private String description;
        private DataFrameAnalyticsSource source;
        private DataFrameAnalyticsDest dest;
        private DataFrameAnalysis analysis;
        private FetchSourceContext analyzedFields;
        private ByteSizeValue modelMemoryLimit;
        private ByteSizeValue maxModelMemoryLimit;
        private Map<String, String> headers = Collections.emptyMap();
        private Instant createTime;
        private Version version;
        private boolean allowLazyStart;
        private Integer maxNumThreads;

        public Builder() {
        }

        public Builder(DataFrameAnalyticsConfig config) {
            this(config, null);
        }

        public Builder(DataFrameAnalyticsConfig config, ByteSizeValue maxModelMemoryLimit) {
            this.id = config.id;
            this.description = config.description;
            this.source = new DataFrameAnalyticsSource(config.source);
            this.dest = new DataFrameAnalyticsDest(config.dest);
            this.analysis = config.analysis;
            this.headers = new HashMap<String, String>(config.headers);
            this.modelMemoryLimit = config.modelMemoryLimit;
            this.maxModelMemoryLimit = maxModelMemoryLimit;
            if (config.analyzedFields != null) {
                this.analyzedFields = new FetchSourceContext(true, config.analyzedFields.includes(), config.analyzedFields.excludes());
            }
            this.createTime = config.createTime;
            this.version = config.version;
            this.allowLazyStart = config.allowLazyStart;
            this.maxNumThreads = config.maxNumThreads;
        }

        public String getId() {
            return this.id;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setId(String id) {
            this.id = ExceptionsHelper.requireNonNull(id, ID);
            return this;
        }

        public Builder setSource(DataFrameAnalyticsSource source) {
            this.source = ExceptionsHelper.requireNonNull(source, SOURCE);
            return this;
        }

        public Builder setDest(DataFrameAnalyticsDest dest) {
            this.dest = ExceptionsHelper.requireNonNull(dest, DEST);
            return this;
        }

        public Builder setAnalysis(DataFrameAnalysis analysis) {
            this.analysis = ExceptionsHelper.requireNonNull(analysis, ANALYSIS);
            return this;
        }

        public Builder setAnalyzedFields(FetchSourceContext fields) {
            this.analyzedFields = fields;
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = headers;
            ClientHelper.assertNoAuthorizationHeader(this.headers);
            return this;
        }

        public Builder setModelMemoryLimit(ByteSizeValue modelMemoryLimit) {
            this.modelMemoryLimit = modelMemoryLimit;
            return this;
        }

        public Builder setCreateTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder setVersion(Version version) {
            this.version = version;
            return this;
        }

        public Builder setAllowLazyStart(boolean isLazyStart) {
            this.allowLazyStart = isLazyStart;
            return this;
        }

        public Builder setMaxNumThreads(Integer maxNumThreads) {
            this.maxNumThreads = maxNumThreads;
            return this;
        }

        public DataFrameAnalyticsConfig build() {
            this.applyMaxModelMemoryLimit();
            return new DataFrameAnalyticsConfig(this.id, this.description, this.source, this.dest, this.analysis, this.headers, this.modelMemoryLimit, this.analyzedFields, this.createTime, this.version, this.allowLazyStart, this.maxNumThreads);
        }

        public DataFrameAnalyticsConfig buildForExplain() {
            return new DataFrameAnalyticsConfig(this.id != null ? this.id : DataFrameAnalyticsConfig.BLANK_ID, this.description, this.source, this.dest != null ? this.dest : new DataFrameAnalyticsDest(DataFrameAnalyticsConfig.BLANK_DEST_INDEX, null), this.analysis, this.headers, this.modelMemoryLimit, this.analyzedFields, this.createTime, this.version, this.allowLazyStart, this.maxNumThreads);
        }

        private void applyMaxModelMemoryLimit() {
            boolean maxModelMemoryIsSet;
            boolean bl = maxModelMemoryIsSet = this.maxModelMemoryLimit != null && this.maxModelMemoryLimit.getMb() > 0L;
            if (this.modelMemoryLimit != null) {
                if (this.modelMemoryLimit.compareTo(MIN_MODEL_MEMORY_LIMIT) < 0) {
                    throw ExceptionsHelper.badRequestException(Messages.getMessage("model_memory_limit must be at least {1}. Value = {0}", this.modelMemoryLimit, MIN_MODEL_MEMORY_LIMIT.getStringRep()), new Object[0]);
                }
                if (maxModelMemoryIsSet && this.modelMemoryLimit.compareTo(this.maxModelMemoryLimit) > 0) {
                    throw ExceptionsHelper.badRequestException(Messages.getMessage(Messages.JOB_CONFIG_MODEL_MEMORY_LIMIT_GREATER_THAN_MAX, this.modelMemoryLimit, this.maxModelMemoryLimit), new Object[0]);
                }
            } else if (maxModelMemoryIsSet && DEFAULT_MODEL_MEMORY_LIMIT.compareTo(this.maxModelMemoryLimit) > 0) {
                this.modelMemoryLimit = this.maxModelMemoryLimit;
            }
        }
    }
}

