/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.preprocessing;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.LenientlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.StrictlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class FrequencyEncoding
implements LenientlyParsedPreProcessor,
StrictlyParsedPreProcessor {
    public static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FrequencyEncoding.class);
    public static final ParseField NAME = new ParseField("frequency_encoding", new String[0]);
    public static final ParseField FIELD = new ParseField("field", new String[0]);
    public static final ParseField FEATURE_NAME = new ParseField("feature_name", new String[0]);
    public static final ParseField FREQUENCY_MAP = new ParseField("frequency_map", new String[0]);
    public static final ParseField CUSTOM = new ParseField("custom", new String[0]);
    private static final ConstructingObjectParser<FrequencyEncoding, PreProcessor.PreProcessorParseContext> STRICT_PARSER = FrequencyEncoding.createParser(false);
    private static final ConstructingObjectParser<FrequencyEncoding, PreProcessor.PreProcessorParseContext> LENIENT_PARSER = FrequencyEncoding.createParser(true);
    private final String field;
    private final String featureName;
    private final Map<String, Double> frequencyMap;
    private final boolean custom;

    private static ConstructingObjectParser<FrequencyEncoding, PreProcessor.PreProcessorParseContext> createParser(boolean lenient) {
        ConstructingObjectParser<FrequencyEncoding, PreProcessor.PreProcessorParseContext> parser = new ConstructingObjectParser<FrequencyEncoding, PreProcessor.PreProcessorParseContext>(NAME.getPreferredName(), lenient, (a, c) -> new FrequencyEncoding((String)a[0], (String)a[1], (Map)a[2], a[3] == null ? c.isCustomByDefault() : ((Boolean)a[3]).booleanValue()));
        parser.declareString(ConstructingObjectParser.constructorArg(), FIELD);
        parser.declareString(ConstructingObjectParser.constructorArg(), FEATURE_NAME);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(HashMap::new, XContentParser::doubleValue), FREQUENCY_MAP);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), CUSTOM);
        return parser;
    }

    public static FrequencyEncoding fromXContentStrict(XContentParser parser, PreProcessor.PreProcessorParseContext context) {
        return STRICT_PARSER.apply(parser, context == null ? PreProcessor.PreProcessorParseContext.DEFAULT : context);
    }

    public static FrequencyEncoding fromXContentLenient(XContentParser parser, PreProcessor.PreProcessorParseContext context) {
        return LENIENT_PARSER.apply(parser, context == null ? PreProcessor.PreProcessorParseContext.DEFAULT : context);
    }

    public FrequencyEncoding(String field, String featureName, Map<String, Double> frequencyMap, Boolean custom) {
        this.field = ExceptionsHelper.requireNonNull(field, FIELD);
        this.featureName = ExceptionsHelper.requireNonNull(featureName, FEATURE_NAME);
        this.frequencyMap = Collections.unmodifiableMap(ExceptionsHelper.requireNonNull(frequencyMap, FREQUENCY_MAP));
        this.custom = custom == null ? false : custom;
    }

    public FrequencyEncoding(StreamInput in) throws IOException {
        this.field = in.readString();
        this.featureName = in.readString();
        this.frequencyMap = Collections.unmodifiableMap(in.readMap(StreamInput::readString, StreamInput::readDouble));
        this.custom = in.getVersion().onOrAfter(Version.V_7_10_0) ? in.readBoolean() : false;
    }

    public String getField() {
        return this.field;
    }

    public Map<String, Double> getFrequencyMap() {
        return this.frequencyMap;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public Map<String, String> reverseLookup() {
        return Collections.singletonMap(this.featureName, this.field);
    }

    @Override
    public boolean isCustom() {
        return this.custom;
    }

    @Override
    public String getOutputFieldType(String outputField) {
        return NumberFieldMapper.NumberType.DOUBLE.typeName();
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public List<String> inputFields() {
        return Collections.singletonList(this.field);
    }

    @Override
    public List<String> outputFields() {
        return Collections.singletonList(this.featureName);
    }

    @Override
    public void process(Map<String, Object> fields) {
        Object value = fields.get(this.field);
        if (value == null) {
            return;
        }
        fields.put(this.featureName, this.frequencyMap.getOrDefault(value.toString(), 0.0));
    }

    @Override
    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeString(this.featureName);
        out.writeMap(this.frequencyMap, StreamOutput::writeString, StreamOutput::writeDouble);
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            out.writeBoolean(this.custom);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD.getPreferredName(), this.field);
        builder.field(FEATURE_NAME.getPreferredName(), this.featureName);
        builder.field(FREQUENCY_MAP.getPreferredName(), this.frequencyMap);
        builder.field(CUSTOM.getPreferredName(), this.custom);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrequencyEncoding that = (FrequencyEncoding)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.featureName, that.featureName) && Objects.equals(this.frequencyMap, that.frequencyMap) && Objects.equals(this.custom, that.custom);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.featureName, this.frequencyMap, this.custom);
    }

    @Override
    public long ramBytesUsed() {
        long size = SHALLOW_SIZE;
        size += RamUsageEstimator.sizeOf(this.field);
        size += RamUsageEstimator.sizeOf(this.featureName);
        return size += RamUsageEstimator.sizeOfMap(this.frequencyMap, 0L);
    }

    public String toString() {
        return Strings.toString(this);
    }
}

