/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.preprocessing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.LenientlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.StrictlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class NGram
implements LenientlyParsedPreProcessor,
StrictlyParsedPreProcessor {
    private static final int DEFAULT_START = 0;
    private static final int DEFAULT_LENGTH = 50;
    private static final int MAX_LENGTH = 100;
    private static final int MIN_GRAM = 1;
    private static final int MAX_GRAM = 5;
    public static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(NGram.class);
    public static final ParseField NAME = new ParseField("n_gram_encoding", new String[0]);
    public static final ParseField FIELD = new ParseField("field", new String[0]);
    public static final ParseField FEATURE_PREFIX = new ParseField("feature_prefix", new String[0]);
    public static final ParseField NGRAMS = new ParseField("n_grams", new String[0]);
    public static final ParseField START = new ParseField("start", new String[0]);
    public static final ParseField LENGTH = new ParseField("length", new String[0]);
    public static final ParseField CUSTOM = new ParseField("custom", new String[0]);
    private static final ConstructingObjectParser<NGram, PreProcessor.PreProcessorParseContext> STRICT_PARSER = NGram.createParser(false);
    private static final ConstructingObjectParser<NGram, PreProcessor.PreProcessorParseContext> LENIENT_PARSER = NGram.createParser(true);
    private final String field;
    private final String featurePrefix;
    private final int[] nGrams;
    private final int start;
    private final int length;
    private final boolean custom;

    private static String defaultPrefix(Integer start, Integer length) {
        return "ngram_" + (start == null ? 0 : start) + "_" + (length == null ? 50 : length);
    }

    private static ConstructingObjectParser<NGram, PreProcessor.PreProcessorParseContext> createParser(boolean lenient) {
        ConstructingObjectParser<NGram, PreProcessor.PreProcessorParseContext> parser = new ConstructingObjectParser<NGram, PreProcessor.PreProcessorParseContext>(NAME.getPreferredName(), lenient, (a, c) -> new NGram((String)a[0], (List)a[1], (Integer)a[2], (Integer)a[3], a[4] == null ? c.isCustomByDefault() : ((Boolean)a[4]).booleanValue(), (String)a[5]));
        parser.declareString(ConstructingObjectParser.constructorArg(), FIELD);
        parser.declareIntArray(ConstructingObjectParser.constructorArg(), NGRAMS);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), START);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), LENGTH);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), CUSTOM);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), FEATURE_PREFIX);
        return parser;
    }

    public static NGram fromXContentStrict(XContentParser parser, PreProcessor.PreProcessorParseContext context) {
        return STRICT_PARSER.apply(parser, context == null ? PreProcessor.PreProcessorParseContext.DEFAULT : context);
    }

    public static NGram fromXContentLenient(XContentParser parser, PreProcessor.PreProcessorParseContext context) {
        return LENIENT_PARSER.apply(parser, context == null ? PreProcessor.PreProcessorParseContext.DEFAULT : context);
    }

    NGram(String field, List<Integer> nGrams, Integer start, Integer length, Boolean custom, String featurePrefix) {
        this(field, featurePrefix == null ? NGram.defaultPrefix(start, length) : featurePrefix, Sets.newHashSet(nGrams).stream().mapToInt(Integer::intValue).toArray(), start == null ? 0 : start, length == null ? 50 : length, custom != null && custom != false);
    }

    public NGram(String field, String featurePrefix, int[] nGrams, int start, int length, boolean custom) {
        this.field = ExceptionsHelper.requireNonNull(field, FIELD);
        this.featurePrefix = ExceptionsHelper.requireNonNull(featurePrefix, FEATURE_PREFIX);
        this.nGrams = ExceptionsHelper.requireNonNull(nGrams, NGRAMS);
        if (nGrams.length == 0) {
            throw ExceptionsHelper.badRequestException("[{}] must not be empty", NGRAMS.getPreferredName());
        }
        if (Arrays.stream(this.nGrams).anyMatch(i -> i < 1 || i > 5)) {
            throw ExceptionsHelper.badRequestException("[{}] is invalid [{}]; minimum supported value is [{}]; maximum supported value is [{}]", NGRAMS.getPreferredName(), Arrays.stream(nGrams).mapToObj(String::valueOf).collect(Collectors.joining(", ")), 1, 5);
        }
        this.start = start;
        if (start < 0 && length + start > 0) {
            throw ExceptionsHelper.badRequestException("if [start] is negative, [length] + [start] must be less than 0", new Object[0]);
        }
        this.length = length;
        if (length <= 0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a positive integer", LENGTH.getPreferredName());
        }
        if (length > 100) {
            throw ExceptionsHelper.badRequestException("[{}] must be not be greater than [{}]", LENGTH.getPreferredName(), 100);
        }
        if (Arrays.stream(this.nGrams).anyMatch(i -> i > length)) {
            throw ExceptionsHelper.badRequestException("[{}] and [{}] are invalid; all ngrams must be shorter than or equal to length [{}]", NGRAMS.getPreferredName(), LENGTH.getPreferredName(), length);
        }
        this.custom = custom;
    }

    public NGram(StreamInput in) throws IOException {
        this.field = in.readString();
        this.featurePrefix = in.readString();
        this.nGrams = in.readVIntArray();
        this.start = in.readInt();
        this.length = in.readVInt();
        this.custom = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeString(this.featurePrefix);
        out.writeVIntArray(this.nGrams);
        out.writeInt(this.start);
        out.writeVInt(this.length);
        out.writeBoolean(this.custom);
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public List<String> inputFields() {
        return Collections.singletonList(this.field);
    }

    @Override
    public List<String> outputFields() {
        return this.allPossibleNGramOutputFeatureNames();
    }

    @Override
    public void process(Map<String, Object> fields) {
        Object value = fields.get(this.field);
        if (value == null) {
            return;
        }
        String stringValue = value.toString();
        if (this.start > stringValue.length() || stringValue.length() + this.start < 0) {
            return;
        }
        int startPos = this.start < 0 ? stringValue.length() + this.start : this.start;
        int len = Math.min(startPos + this.length, stringValue.length());
        for (int nGram : this.nGrams) {
            for (int i = 0; i < len && startPos + i + nGram <= len; ++i) {
                fields.put(this.nGramFeature(nGram, i), stringValue.substring(startPos + i, startPos + i + nGram));
            }
        }
    }

    @Override
    public Map<String, String> reverseLookup() {
        return this.outputFields().stream().collect(Collectors.toMap(Function.identity(), ignored -> this.field));
    }

    @Override
    public String getOutputFieldType(String outputField) {
        return "text";
    }

    @Override
    public long ramBytesUsed() {
        long size = SHALLOW_SIZE;
        size += RamUsageEstimator.sizeOf(this.field);
        size += RamUsageEstimator.sizeOf(this.featurePrefix);
        return size += RamUsageEstimator.sizeOf(this.nGrams);
    }

    @Override
    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD.getPreferredName(), this.field);
        builder.field(FEATURE_PREFIX.getPreferredName(), this.featurePrefix);
        builder.field(NGRAMS.getPreferredName(), this.nGrams);
        builder.field(START.getPreferredName(), this.start);
        builder.field(LENGTH.getPreferredName(), this.length);
        builder.field(CUSTOM.getPreferredName(), this.custom);
        builder.endObject();
        return builder;
    }

    public String getField() {
        return this.field;
    }

    public String getFeaturePrefix() {
        return this.featurePrefix;
    }

    public int[] getnGrams() {
        return this.nGrams;
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public boolean isCustom() {
        return this.custom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NGram nGram = (NGram)o;
        return this.start == nGram.start && this.length == nGram.length && this.custom == nGram.custom && Objects.equals(this.field, nGram.field) && Objects.equals(this.featurePrefix, nGram.featurePrefix) && Arrays.equals(this.nGrams, nGram.nGrams);
    }

    public int hashCode() {
        int result = Objects.hash(this.field, this.featurePrefix, this.start, this.length, this.custom);
        result = 31 * result + Arrays.hashCode(this.nGrams);
        return result;
    }

    private String nGramFeature(int nGram, int pos) {
        return this.featurePrefix + "." + nGram + pos;
    }

    private List<String> allPossibleNGramOutputFeatureNames() {
        int totalNgrams = 0;
        for (int nGram : this.nGrams) {
            totalNgrams += this.length - (nGram - 1);
        }
        if (totalNgrams <= 0) {
            return Collections.emptyList();
        }
        ArrayList<String> ngramOutputs = new ArrayList<String>(totalNgrams);
        for (int nGram : this.nGrams) {
            IntFunction<String> func = i -> this.nGramFeature(nGram, i);
            IntStream.range(0, this.length - (nGram - 1)).mapToObj(func).forEach(ngramOutputs::add);
        }
        return ngramOutputs;
    }
}

