/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.util.Map;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public interface InferenceResults
extends NamedWriteable,
ToXContentFragment {
    public static final String MODEL_ID_RESULTS_FIELD = "model_id";

    public static void writeResult(InferenceResults results, IngestDocument ingestDocument, String resultField, String modelId) {
        ExceptionsHelper.requireNonNull(results, "results");
        ExceptionsHelper.requireNonNull(ingestDocument, "ingestDocument");
        ExceptionsHelper.requireNonNull(resultField, "resultField");
        Map<String, Object> resultMap = results.asMap();
        resultMap.put(MODEL_ID_RESULTS_FIELD, modelId);
        if (ingestDocument.hasField(resultField)) {
            ingestDocument.appendFieldValue(resultField, resultMap);
        } else {
            ingestDocument.setFieldValue(resultField, resultMap);
        }
    }

    public Map<String, Object> asMap();

    public Object predictedValue();
}

