/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.utils;

import org.elasticsearch.common.Numbers;

public final class Statistics {
    private Statistics() {
    }

    public static double[] softMax(double[] values) {
        int i;
        double expSum = 0.0;
        double max = Double.NEGATIVE_INFINITY;
        for (double val : values) {
            if (!Statistics.isValid(val)) continue;
            max = Math.max(max, val);
        }
        if (!Statistics.isValid(max)) {
            throw new IllegalArgumentException("no valid values present");
        }
        double[] exps = new double[values.length];
        for (i = 0; i < exps.length; ++i) {
            if (Statistics.isValid(values[i])) {
                double exp = Math.exp(values[i] - max);
                expSum += exp;
                exps[i] = exp;
                continue;
            }
            exps[i] = Double.NaN;
        }
        for (i = 0; i < exps.length; ++i) {
            if (Statistics.isValid(exps[i])) {
                int n = i;
                exps[n] = exps[n] / expSum;
                continue;
            }
            exps[i] = 0.0;
        }
        return exps;
    }

    public static double sigmoid(double value) {
        return 1.0 / (1.0 + Math.exp(-value));
    }

    private static boolean isValid(double v) {
        return Numbers.isValidDouble(v);
    }
}

