/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.realm;

import java.io.IOException;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClearRealmCacheRequest
extends BaseNodesRequest<ClearRealmCacheRequest> {
    String[] realms;
    String[] usernames;

    public ClearRealmCacheRequest() {
        super((String[])null);
    }

    public ClearRealmCacheRequest(StreamInput in) throws IOException {
        super(in);
        this.realms = in.readStringArray();
        this.usernames = in.readStringArray();
    }

    public boolean allRealms() {
        return this.realms == null || this.realms.length == 0;
    }

    public String[] realms() {
        return this.realms;
    }

    public ClearRealmCacheRequest realms(String ... realms) {
        this.realms = realms;
        return this;
    }

    public boolean allUsernames() {
        return this.usernames == null || this.usernames.length == 0;
    }

    public String[] usernames() {
        return this.usernames;
    }

    public ClearRealmCacheRequest usernames(String ... usernames) {
        this.usernames = usernames;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.realms);
        out.writeStringArrayNullable(this.usernames);
    }

    public static class Node
    extends BaseNodeRequest {
        private String[] realms;
        private String[] usernames;

        public Node(StreamInput in) throws IOException {
            super(in);
            this.realms = in.readStringArray();
            this.usernames = in.readStringArray();
        }

        public Node(ClearRealmCacheRequest request) {
            this.realms = request.realms;
            this.usernames = request.usernames;
        }

        public String[] getRealms() {
            return this.realms;
        }

        public String[] getUsernames() {
            return this.usernames;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArrayNullable(this.realms);
            out.writeStringArrayNullable(this.usernames);
        }
    }
}

