/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.accesscontrol;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.authz.permission.DocumentPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.support.SecurityQueryTemplateEvaluator;
import org.elasticsearch.xpack.core.security.support.CacheKey;

public class IndicesAccessControl {
    public static final IndicesAccessControl ALLOW_ALL = new IndicesAccessControl(true, Collections.emptyMap());
    public static final IndicesAccessControl ALLOW_NO_INDICES = new IndicesAccessControl(true, Collections.singletonMap("-*", new IndexAccessControl(true, new FieldPermissions(), DocumentPermissions.allowAll())));
    public static final IndicesAccessControl DENIED = new IndicesAccessControl(false, Collections.emptyMap());
    private final boolean granted;
    private final Map<String, IndexAccessControl> indexPermissions;

    public IndicesAccessControl(boolean granted, Map<String, IndexAccessControl> indexPermissions) {
        this.granted = granted;
        this.indexPermissions = indexPermissions;
    }

    @Nullable
    public IndexAccessControl getIndexPermissions(String index) {
        return this.indexPermissions.get(index);
    }

    public boolean isGranted() {
        return this.granted;
    }

    public Collection<?> getDeniedIndices() {
        return Collections.unmodifiableSet(this.indexPermissions.entrySet().stream().filter(e -> !((IndexAccessControl)e.getValue()).granted).map(Map.Entry::getKey).collect(Collectors.toSet()));
    }

    public IndicesAccessControl limitIndicesAccessControl(IndicesAccessControl limitedByIndicesAccessControl) {
        boolean granted = this.granted == limitedByIndicesAccessControl.granted ? this.granted : false;
        Set<String> indexes = this.indexPermissions.keySet();
        Set<String> otherIndexes = limitedByIndicesAccessControl.indexPermissions.keySet();
        Set<String> commonIndexes = Sets.intersection(indexes, otherIndexes);
        HashMap<String, IndexAccessControl> indexPermissions = new HashMap<String, IndexAccessControl>(commonIndexes.size());
        for (String index : commonIndexes) {
            IndexAccessControl indexAccessControl = this.getIndexPermissions(index);
            IndexAccessControl limitedByIndexAccessControl = limitedByIndicesAccessControl.getIndexPermissions(index);
            indexPermissions.put(index, indexAccessControl.limitIndexAccessControl(limitedByIndexAccessControl));
        }
        return new IndicesAccessControl(granted, indexPermissions);
    }

    public String toString() {
        return "IndicesAccessControl{granted=" + this.granted + ", indexPermissions=" + this.indexPermissions + '}';
    }

    public static class IndexAccessControl
    implements CacheKey {
        private final boolean granted;
        private final FieldPermissions fieldPermissions;
        private final DocumentPermissions documentPermissions;

        public IndexAccessControl(boolean granted, FieldPermissions fieldPermissions, DocumentPermissions documentPermissions) {
            this.granted = granted;
            this.fieldPermissions = fieldPermissions == null ? FieldPermissions.DEFAULT : fieldPermissions;
            this.documentPermissions = documentPermissions == null ? DocumentPermissions.allowAll() : documentPermissions;
        }

        public boolean isGranted() {
            return this.granted;
        }

        public FieldPermissions getFieldPermissions() {
            return this.fieldPermissions;
        }

        @Nullable
        public DocumentPermissions getDocumentPermissions() {
            return this.documentPermissions;
        }

        public IndexAccessControl limitIndexAccessControl(IndexAccessControl limitedByIndexAccessControl) {
            boolean granted = this.granted == limitedByIndexAccessControl.granted ? this.granted : false;
            FieldPermissions fieldPermissions = this.getFieldPermissions().limitFieldPermissions(limitedByIndexAccessControl.fieldPermissions);
            DocumentPermissions documentPermissions = this.getDocumentPermissions().limitDocumentPermissions(limitedByIndexAccessControl.getDocumentPermissions());
            return new IndexAccessControl(granted, fieldPermissions, documentPermissions);
        }

        public String toString() {
            return "IndexAccessControl{granted=" + this.granted + ", fieldPermissions=" + this.fieldPermissions + ", documentPermissions=" + this.documentPermissions + '}';
        }

        @Override
        public void buildCacheKey(StreamOutput out, SecurityQueryTemplateEvaluator.DlsQueryEvaluationContext context) throws IOException {
            if (this.documentPermissions.hasDocumentLevelPermissions()) {
                out.writeBoolean(true);
                this.documentPermissions.buildCacheKey(out, context);
            } else {
                out.writeBoolean(false);
            }
            if (this.fieldPermissions.hasFieldLevelSecurity()) {
                out.writeBoolean(true);
                this.fieldPermissions.buildCacheKey(out, context);
            } else {
                out.writeBoolean(false);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexAccessControl that = (IndexAccessControl)o;
            return this.granted == that.granted && Objects.equals(this.fieldPermissions, that.fieldPermissions) && Objects.equals(this.documentPermissions, that.documentPermissions);
        }

        public int hashCode() {
            return Objects.hash(this.granted, this.fieldPermissions, this.documentPermissions);
        }
    }
}

