/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.transport;

import java.util.function.BiConsumer;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.xpack.core.security.transport.SSLExceptionHelper;

public final class SecurityTransportExceptionHandler
implements BiConsumer<TcpChannel, Exception> {
    private final Lifecycle lifecycle;
    private final Logger logger;
    private final BiConsumer<TcpChannel, Exception> fallback;

    public SecurityTransportExceptionHandler(Logger logger, Lifecycle lifecycle, BiConsumer<TcpChannel, Exception> fallback) {
        this.lifecycle = lifecycle;
        this.logger = logger;
        this.fallback = fallback;
    }

    @Override
    public void accept(TcpChannel channel, Exception e) {
        if (!this.lifecycle.started()) {
            CloseableChannel.closeChannel(channel);
        } else if (SSLExceptionHelper.isNotSslRecordException(e)) {
            this.logger.warn("received plaintext traffic on an encrypted channel, closing connection {}", (Object)channel);
            CloseableChannel.closeChannel(channel);
        } else if (SSLExceptionHelper.isCloseDuringHandshakeException(e)) {
            this.logger.debug("connection {} closed during handshake", (Object)channel);
            CloseableChannel.closeChannel(channel);
        } else if (SSLExceptionHelper.isInsufficientBufferRemainingException(e)) {
            this.logger.debug("connection {} closed abruptly", (Object)channel);
            CloseableChannel.closeChannel(channel);
        } else if (SSLExceptionHelper.isReceivedCertificateUnknownException(e)) {
            this.logger.warn("client did not trust this server's certificate, closing connection {}", (Object)channel);
            CloseableChannel.closeChannel(channel);
        } else {
            this.fallback.accept(channel, e);
        }
    }
}

