/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.actions;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.core.watcher.actions.ActionWrapperField;
import org.elasticsearch.xpack.core.watcher.condition.Condition;
import org.elasticsearch.xpack.core.watcher.transform.Transform;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;

public class ActionWrapperResult
implements ToXContentObject {
    private final String id;
    @Nullable
    private final Condition.Result condition;
    @Nullable
    private final Transform.Result transform;
    private final Action.Result action;

    public ActionWrapperResult(String id, Action.Result action) {
        this(id, null, null, action);
    }

    public ActionWrapperResult(String id, @Nullable Condition.Result condition, @Nullable Transform.Result transform, Action.Result action) {
        this.id = id;
        this.condition = condition;
        this.transform = transform;
        this.action = action;
    }

    public String id() {
        return this.id;
    }

    public Condition.Result condition() {
        return this.condition;
    }

    public Transform.Result transform() {
        return this.transform;
    }

    public Action.Result action() {
        return this.action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionWrapperResult result = (ActionWrapperResult)o;
        return Objects.equals(this.id, result.id) && Objects.equals(this.condition, result.condition) && Objects.equals(this.transform, result.transform) && Objects.equals(this.action, result.action);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.condition, this.transform, this.action);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ActionWrapperField.ID.getPreferredName(), this.id);
        builder.field(ActionWrapperField.TYPE.getPreferredName(), this.action.type());
        builder.field(ActionWrapperField.STATUS.getPreferredName(), this.action.status().value());
        if (this.condition != null) {
            builder.field(WatchField.CONDITION.getPreferredName(), this.condition, params);
        }
        if (this.transform != null) {
            builder.field(Transform.TRANSFORM.getPreferredName(), this.transform, params);
        }
        this.action.toXContent(builder, params);
        return builder.endObject();
    }
}

