/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.transform.chain;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.transform.ExecutableTransform;
import org.elasticsearch.xpack.core.watcher.transform.Transform;
import org.elasticsearch.xpack.core.watcher.transform.TransformFactory;
import org.elasticsearch.xpack.core.watcher.transform.TransformRegistry;
import org.elasticsearch.xpack.core.watcher.transform.chain.ChainTransform;
import org.elasticsearch.xpack.core.watcher.transform.chain.ExecutableChainTransform;

public final class ChainTransformFactory
extends TransformFactory<ChainTransform, ChainTransform.Result, ExecutableChainTransform> {
    private final TransformRegistry registry;

    public ChainTransformFactory(TransformRegistry registry) {
        super(LogManager.getLogger(ExecutableChainTransform.class));
        this.registry = registry;
    }

    @Override
    public String type() {
        return "chain";
    }

    @Override
    public ChainTransform parseTransform(String watchId, XContentParser parser) throws IOException {
        return ChainTransform.parse(watchId, parser, this.registry);
    }

    @Override
    public ExecutableChainTransform createExecutable(ChainTransform chainTransform) {
        ArrayList<ExecutableTransform> executables = new ArrayList<ExecutableTransform>();
        for (Transform transform : chainTransform.getTransforms()) {
            TransformFactory<Transform, Transform.Result, ExecutableTransform<?, ?>> factory = this.registry.factory(transform.type());
            executables.add(factory.createExecutable(transform));
        }
        return new ExecutableChainTransform(chainTransform, this.transformLogger, executables);
    }
}

