/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.LeaderBulkByScrollTaskState;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.slice.SliceBuilder;
import org.elasticsearch.tasks.TaskId;

class BulkByScrollParallelizationHelper {
    static final int AUTO_SLICE_CEILING = 20;

    private BulkByScrollParallelizationHelper() {
    }

    static <Request extends AbstractBulkByScrollRequest<Request>> void startSlicedAction(Request request, BulkByScrollTask task, ActionType<BulkByScrollResponse> action, ActionListener<BulkByScrollResponse> listener, Client client, DiscoveryNode node, Runnable workerAction) {
        BulkByScrollParallelizationHelper.initTaskState(task, request, client, (ActionListener<Void>)listener.delegateFailure((l, v) -> BulkByScrollParallelizationHelper.executeSlicedAction(task, request, action, (ActionListener<BulkByScrollResponse>)l, client, node, workerAction)));
    }

    static <Request extends AbstractBulkByScrollRequest<Request>> void executeSlicedAction(BulkByScrollTask task, Request request, ActionType<BulkByScrollResponse> action, ActionListener<BulkByScrollResponse> listener, Client client, DiscoveryNode node, Runnable workerAction) {
        if (task.isLeader()) {
            BulkByScrollParallelizationHelper.sendSubRequests(client, action, node.getId(), task, request, listener);
        } else if (task.isWorker()) {
            workerAction.run();
        } else {
            throw new AssertionError((Object)"Task should have been initialized at this point.");
        }
    }

    static <Request extends AbstractBulkByScrollRequest<Request>> void initTaskState(BulkByScrollTask task, Request request, Client client, ActionListener<Void> listener) {
        int configuredSlices = request.getSlices();
        if (configuredSlices == 0) {
            ClusterSearchShardsRequest shardsRequest = new ClusterSearchShardsRequest();
            shardsRequest.indices(request.getSearchRequest().indices());
            client.admin().cluster().searchShards(shardsRequest, listener.delegateFailure((l, response) -> {
                BulkByScrollParallelizationHelper.setWorkerCount(request, task, BulkByScrollParallelizationHelper.countSlicesBasedOnShards(response));
                l.onResponse(null);
            }));
        } else {
            BulkByScrollParallelizationHelper.setWorkerCount(request, task, configuredSlices);
            listener.onResponse(null);
        }
    }

    private static <Request extends AbstractBulkByScrollRequest<Request>> void setWorkerCount(Request request, BulkByScrollTask task, int slices) {
        if (slices > 1) {
            task.setWorkerCount(slices);
        } else {
            SliceBuilder sliceBuilder = request.getSearchRequest().source().slice();
            Integer sliceId = sliceBuilder == null ? null : Integer.valueOf(sliceBuilder.getId());
            task.setWorker(request.getRequestsPerSecond(), sliceId);
        }
    }

    private static int countSlicesBasedOnShards(ClusterSearchShardsResponse response) {
        Map<Index, Integer> countsByIndex = Arrays.stream(response.getGroups()).collect(Collectors.toMap(group -> group.getShardId().getIndex(), group -> 1, (sum, term) -> sum + term));
        HashSet<Integer> counts = new HashSet<Integer>(countsByIndex.values());
        int leastShards = counts.isEmpty() ? 1 : Collections.min(counts);
        return Math.min(leastShards, 20);
    }

    private static <Request extends AbstractBulkByScrollRequest<Request>> void sendSubRequests(Client client, ActionType<BulkByScrollResponse> action, String localNodeId, BulkByScrollTask task, Request request, ActionListener<BulkByScrollResponse> listener) {
        LeaderBulkByScrollTaskState worker = task.getLeaderState();
        int totalSlices = worker.getSlices();
        TaskId parentTaskId = new TaskId(localNodeId, task.getId());
        for (SearchRequest slice : BulkByScrollParallelizationHelper.sliceIntoSubRequests(request.getSearchRequest(), "_id", totalSlices)) {
            AbstractBulkByScrollRequest requestForSlice = request.forSlice(parentTaskId, slice, totalSlices);
            ActionListener sliceListener = ActionListener.wrap(r -> worker.onSliceResponse(listener, slice.source().slice().getId(), r), e -> worker.onSliceFailure(listener, slice.source().slice().getId(), e));
            client.execute(action, (ActionRequest)requestForSlice, sliceListener);
        }
    }

    static SearchRequest[] sliceIntoSubRequests(SearchRequest request, String field, int times) {
        SearchRequest[] slices = new SearchRequest[times];
        for (int slice = 0; slice < times; ++slice) {
            SearchSourceBuilder slicedSource;
            SliceBuilder sliceBuilder = new SliceBuilder(field, slice, times);
            if (request.source() == null) {
                slicedSource = new SearchSourceBuilder().slice(sliceBuilder);
            } else {
                if (request.source().slice() != null) {
                    throw new IllegalStateException("Can't slice a request that already has a slice configuration");
                }
                slicedSource = request.source().shallowCopy().slice(sliceBuilder);
            }
            SearchRequest searchRequest = new SearchRequest(request);
            searchRequest.source(slicedSource);
            slices[slice] = searchRequest;
        }
        return slices;
    }
}

