/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicyMetadata;
import org.elasticsearch.xpack.core.XPackPlugin;

public class AutoscalingMetadata
implements XPackPlugin.XPackMetadataCustom,
Metadata.NonRestorableCustom {
    public static final String NAME = "autoscaling";
    public static final AutoscalingMetadata EMPTY = new AutoscalingMetadata(Collections.emptySortedMap());
    private static final ParseField POLICIES_FIELD = new ParseField("policies", new String[0]);
    private static final ConstructingObjectParser<AutoscalingMetadata, Void> PARSER = new ConstructingObjectParser("autoscaling", c -> new AutoscalingMetadata(new TreeMap<String, AutoscalingPolicyMetadata>(((List)c[0]).stream().collect(Collectors.toMap(p -> p.policy().name(), Function.identity())))));
    private final SortedMap<String, AutoscalingPolicyMetadata> policies;

    public static AutoscalingMetadata parse(XContentParser parser) {
        return (AutoscalingMetadata)PARSER.apply(parser, null);
    }

    public SortedMap<String, AutoscalingPolicyMetadata> policies() {
        return this.policies;
    }

    public AutoscalingMetadata(SortedMap<String, AutoscalingPolicyMetadata> policies) {
        this.policies = policies;
    }

    public AutoscalingMetadata(StreamInput in) throws IOException {
        int size = in.readVInt();
        TreeMap<String, AutoscalingPolicyMetadata> policies = new TreeMap<String, AutoscalingPolicyMetadata>();
        for (int i = 0; i < size; ++i) {
            AutoscalingPolicyMetadata policyMetadata = new AutoscalingPolicyMetadata(in);
            policies.put(policyMetadata.policy().name(), policyMetadata);
        }
        this.policies = policies;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.policies.size());
        for (Map.Entry<String, AutoscalingPolicyMetadata> policy : this.policies.entrySet()) {
            policy.getValue().writeTo(out);
        }
    }

    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
        return new AutoscalingMetadataDiff((AutoscalingMetadata)previousState, this);
    }

    public String getWriteableName() {
        return NAME;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_7_8_0;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(POLICIES_FIELD.getPreferredName(), this.policies);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoscalingMetadata metadata = (AutoscalingMetadata)o;
        return this.policies.equals(metadata.policies);
    }

    public int hashCode() {
        return Objects.hash(this.policies);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> AutoscalingPolicyMetadata.parse(p, n), POLICIES_FIELD);
    }

    public static class AutoscalingMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final Diff<Map<String, AutoscalingPolicyMetadata>> policies;

        public AutoscalingMetadataDiff(AutoscalingMetadata before, AutoscalingMetadata after) {
            this.policies = DiffableUtils.diff((Map)before.policies, (Map)after.policies, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer());
        }

        public AutoscalingMetadataDiff(StreamInput in) throws IOException {
            this.policies = DiffableUtils.readJdkMapDiff((StreamInput)in, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer(), AutoscalingPolicyMetadata::new, AutoscalingMetadataDiff::readFrom);
        }

        public Metadata.Custom apply(Metadata.Custom part) {
            return new AutoscalingMetadata(new TreeMap<String, AutoscalingPolicyMetadata>((Map)this.policies.apply((Object)((AutoscalingMetadata)part).policies)));
        }

        public String getWriteableName() {
            return AutoscalingMetadata.NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.policies.writeTo(out);
        }

        static Diff<AutoscalingPolicyMetadata> readFrom(StreamInput in) throws IOException {
            return AbstractDiffable.readDiffFrom(AutoscalingPolicyMetadata::new, (StreamInput)in);
        }
    }
}

