/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.storage;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCapacity;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderContext;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResult;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderService;
import org.elasticsearch.xpack.autoscaling.util.FrozenUtils;

public class FrozenStorageDeciderService
implements AutoscalingDeciderService {
    public static final String NAME = "frozen_storage";
    static final double DEFAULT_PERCENTAGE = 5.0;
    public static final Setting<Double> PERCENTAGE = Setting.doubleSetting((String)"percentage", (double)5.0, (double)0.0, (Setting.Property[])new Setting.Property[0]);

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public AutoscalingDeciderResult scale(Settings configuration, AutoscalingDeciderContext context) {
        Metadata metadata = context.state().metadata();
        long dataSetSize = StreamSupport.stream(metadata.spliterator(), false).filter(imd -> FrozenUtils.isFrozenIndex(imd.getSettings())).mapToLong(imd -> FrozenStorageDeciderService.estimateSize(imd, context.info())).sum();
        long storageSize = (long)((Double)PERCENTAGE.get(configuration) * (double)dataSetSize) / 100L;
        return new AutoscalingDeciderResult(AutoscalingCapacity.builder().total(storageSize, null).build(), new FrozenReason(dataSetSize));
    }

    static long estimateSize(IndexMetadata imd, ClusterInfo info) {
        int copies = imd.getNumberOfReplicas() + 1;
        long sum = 0L;
        for (int i = 0; i < imd.getNumberOfShards(); ++i) {
            ShardId shardId = new ShardId(imd.getIndex(), i);
            long size = info.getShardDataSetSize(shardId).orElse(0L);
            sum += size * (long)copies;
        }
        return sum;
    }

    @Override
    public List<Setting<?>> deciderSettings() {
        return org.elasticsearch.core.List.of(PERCENTAGE);
    }

    @Override
    public List<DiscoveryNodeRole> roles() {
        return org.elasticsearch.core.List.of((Object)DiscoveryNodeRole.DATA_FROZEN_NODE_ROLE);
    }

    public static class FrozenReason
    implements AutoscalingDeciderResult.Reason {
        private final long totalDataSetSize;

        public FrozenReason(long totalDataSetSize) {
            assert (totalDataSetSize >= 0L);
            this.totalDataSetSize = totalDataSetSize;
        }

        public FrozenReason(StreamInput in) throws IOException {
            this.totalDataSetSize = in.readLong();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("total_data_set_size", this.totalDataSetSize);
            builder.endObject();
            return builder;
        }

        public String getWriteableName() {
            return FrozenStorageDeciderService.NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.totalDataSetSize);
        }

        @Override
        public String summary() {
            return "total data set size [" + this.totalDataSetSize + "]";
        }

        public long totalDataSetSize() {
            return this.totalDataSetSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FrozenReason that = (FrozenReason)o;
            return this.totalDataSetSize == that.totalDataSetSize;
        }

        public int hashCode() {
            return Objects.hash(this.totalDataSetSize);
        }
    }
}

