/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.nio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.nio.ByteBufUtils;
import org.elasticsearch.http.nio.NioHttpResponse;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class NioHttpRequest
implements HttpRequest {
    private final FullHttpRequest request;
    private final BytesReference content;
    private final HttpHeadersMap headers;
    private final AtomicBoolean released;
    private final Exception inboundException;
    private final boolean pooled;

    NioHttpRequest(FullHttpRequest request) {
        this(request, new HttpHeadersMap(request.headers()), new AtomicBoolean(false), true, ByteBufUtils.toBytesReference(request.content()));
    }

    NioHttpRequest(FullHttpRequest request, Exception inboundException) {
        this(request, new HttpHeadersMap(request.headers()), new AtomicBoolean(false), true, ByteBufUtils.toBytesReference(request.content()), inboundException);
    }

    private NioHttpRequest(FullHttpRequest request, HttpHeadersMap headers, AtomicBoolean released, boolean pooled, BytesReference content) {
        this(request, headers, released, pooled, content, null);
    }

    private NioHttpRequest(FullHttpRequest request, HttpHeadersMap headers, AtomicBoolean released, boolean pooled, BytesReference content, Exception inboundException) {
        this.request = request;
        this.headers = headers;
        this.content = content;
        this.pooled = pooled;
        this.released = released;
        this.inboundException = inboundException;
    }

    public RestRequest.Method method() {
        HttpMethod httpMethod = this.request.method();
        if (httpMethod == HttpMethod.GET) {
            return RestRequest.Method.GET;
        }
        if (httpMethod == HttpMethod.POST) {
            return RestRequest.Method.POST;
        }
        if (httpMethod == HttpMethod.PUT) {
            return RestRequest.Method.PUT;
        }
        if (httpMethod == HttpMethod.DELETE) {
            return RestRequest.Method.DELETE;
        }
        if (httpMethod == HttpMethod.HEAD) {
            return RestRequest.Method.HEAD;
        }
        if (httpMethod == HttpMethod.OPTIONS) {
            return RestRequest.Method.OPTIONS;
        }
        if (httpMethod == HttpMethod.PATCH) {
            return RestRequest.Method.PATCH;
        }
        if (httpMethod == HttpMethod.TRACE) {
            return RestRequest.Method.TRACE;
        }
        if (httpMethod == HttpMethod.CONNECT) {
            return RestRequest.Method.CONNECT;
        }
        throw new IllegalArgumentException("Unexpected http method: " + httpMethod);
    }

    public String uri() {
        return this.request.uri();
    }

    public BytesReference content() {
        assert (!this.released.get());
        return this.content;
    }

    public void release() {
        if (this.pooled && this.released.compareAndSet(false, true)) {
            this.request.release();
        }
    }

    public HttpRequest releaseAndCopy() {
        assert (!this.released.get());
        if (!this.pooled) {
            return this;
        }
        try {
            ByteBuf copiedContent = Unpooled.copiedBuffer((ByteBuf)this.request.content());
            NioHttpRequest nioHttpRequest = new NioHttpRequest((FullHttpRequest)new DefaultFullHttpRequest(this.request.protocolVersion(), this.request.method(), this.request.uri(), copiedContent, this.request.headers(), this.request.trailingHeaders()), this.headers, new AtomicBoolean(false), false, ByteBufUtils.toBytesReference(copiedContent));
            return nioHttpRequest;
        }
        finally {
            this.release();
        }
    }

    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<String> strictCookies() {
        Set cookies;
        String cookieString = this.request.headers().get((CharSequence)HttpHeaderNames.COOKIE);
        if (cookieString != null && !(cookies = ServerCookieDecoder.STRICT.decode(cookieString)).isEmpty()) {
            return ServerCookieEncoder.STRICT.encode((Collection)cookies);
        }
        return Collections.emptyList();
    }

    public HttpRequest.HttpVersion protocolVersion() {
        if (this.request.protocolVersion().equals((Object)HttpVersion.HTTP_1_0)) {
            return HttpRequest.HttpVersion.HTTP_1_0;
        }
        if (this.request.protocolVersion().equals((Object)HttpVersion.HTTP_1_1)) {
            return HttpRequest.HttpVersion.HTTP_1_1;
        }
        throw new IllegalArgumentException("Unexpected http protocol version: " + this.request.protocolVersion());
    }

    public HttpRequest removeHeader(String header) {
        DefaultHttpHeaders headersWithoutContentTypeHeader = new DefaultHttpHeaders();
        headersWithoutContentTypeHeader.add(this.request.headers());
        headersWithoutContentTypeHeader.remove(header);
        DefaultHttpHeaders trailingHeaders = new DefaultHttpHeaders();
        trailingHeaders.add(this.request.trailingHeaders());
        trailingHeaders.remove(header);
        DefaultFullHttpRequest requestWithoutHeader = new DefaultFullHttpRequest(this.request.protocolVersion(), this.request.method(), this.request.uri(), this.request.content(), (HttpHeaders)headersWithoutContentTypeHeader, (HttpHeaders)trailingHeaders);
        return new NioHttpRequest((FullHttpRequest)requestWithoutHeader, new HttpHeadersMap(requestWithoutHeader.headers()), this.released, this.pooled, this.content);
    }

    public NioHttpResponse createResponse(RestStatus status, BytesReference content) {
        return new NioHttpResponse(this.request.headers(), this.request.protocolVersion(), status, content);
    }

    public Exception getInboundException() {
        return this.inboundException;
    }

    public FullHttpRequest nettyRequest() {
        return this.request;
    }

    private static class HttpHeadersMap
    implements Map<String, List<String>> {
        private final HttpHeaders httpHeaders;

        private HttpHeadersMap(HttpHeaders httpHeaders) {
            this.httpHeaders = httpHeaders;
        }

        @Override
        public int size() {
            return this.httpHeaders.size();
        }

        @Override
        public boolean isEmpty() {
            return this.httpHeaders.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return key instanceof String && this.httpHeaders.contains((String)key);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean containsValue(Object value) {
            if (!(value instanceof List)) return false;
            if (!this.httpHeaders.names().stream().map(arg_0 -> ((HttpHeaders)this.httpHeaders).getAll(arg_0)).anyMatch(value::equals)) return false;
            return true;
        }

        @Override
        public List<String> get(Object key) {
            return key instanceof String ? this.httpHeaders.getAll((String)key) : null;
        }

        @Override
        public List<String> put(String key, List<String> value) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public List<String> remove(Object key) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public void putAll(Map<? extends String, ? extends List<String>> m) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public Set<String> keySet() {
            return this.httpHeaders.names();
        }

        @Override
        public Collection<List<String>> values() {
            return this.httpHeaders.names().stream().map(k -> Collections.unmodifiableList(this.httpHeaders.getAll(k))).collect(Collectors.toList());
        }

        @Override
        public Set<Map.Entry<String, List<String>>> entrySet() {
            return this.httpHeaders.names().stream().map(k -> new AbstractMap.SimpleImmutableEntry<String, List>((String)k, this.httpHeaders.getAll(k))).collect(Collectors.toSet());
        }
    }
}

