/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ccr.action.FollowInfoAction;
import org.elasticsearch.xpack.core.ccr.action.FollowParameters;
import org.elasticsearch.xpack.core.ccr.action.ShardFollowTask;

public class TransportFollowInfoAction
extends TransportMasterNodeReadAction<FollowInfoAction.Request, FollowInfoAction.Response> {
    @Inject
    public TransportFollowInfoAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:monitor/ccr/follow_info", transportService, clusterService, threadPool, actionFilters, FollowInfoAction.Request::new, indexNameExpressionResolver, FollowInfoAction.Response::new, "same");
    }

    protected void masterOperation(FollowInfoAction.Request request, ClusterState state, ActionListener<FollowInfoAction.Response> listener) throws Exception {
        List<String> concreteFollowerIndices = Arrays.asList(this.indexNameExpressionResolver.concreteIndexNames(state, IndicesOptions.STRICT_EXPAND_OPEN_CLOSED, request.getFollowerIndices()));
        List<FollowInfoAction.Response.FollowerInfo> followerInfos = TransportFollowInfoAction.getFollowInfos(concreteFollowerIndices, state);
        listener.onResponse((Object)new FollowInfoAction.Response(followerInfos));
    }

    protected ClusterBlockException checkBlock(FollowInfoAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    static List<FollowInfoAction.Response.FollowerInfo> getFollowInfos(List<String> concreteFollowerIndices, ClusterState state) {
        ArrayList<FollowInfoAction.Response.FollowerInfo> followerInfos = new ArrayList<FollowInfoAction.Response.FollowerInfo>();
        PersistentTasksCustomMetadata persistentTasks = (PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks");
        for (String index : concreteFollowerIndices) {
            IndexMetadata indexMetadata = state.metadata().index(index);
            Map ccrCustomData = indexMetadata.getCustomData("ccr");
            if (ccrCustomData == null) continue;
            Optional<Object> result = persistentTasks != null ? persistentTasks.findTasks("xpack/ccr/shard_follow_task", task -> true).stream().map(task -> (ShardFollowTask)task.getParams()).filter(shardFollowTask -> index.equals(shardFollowTask.getFollowShardId().getIndexName())).findAny() : Optional.empty();
            String followerIndex = indexMetadata.getIndex().getName();
            String remoteCluster = (String)ccrCustomData.get("remote_cluster_name");
            String leaderIndex = (String)ccrCustomData.get("leader_index_name");
            if (result.isPresent()) {
                ShardFollowTask params = (ShardFollowTask)result.get();
                FollowParameters followParameters = new FollowParameters();
                followParameters.setMaxOutstandingReadRequests(params.getMaxOutstandingReadRequests());
                followParameters.setMaxOutstandingWriteRequests(params.getMaxOutstandingWriteRequests());
                followParameters.setMaxReadRequestOperationCount(params.getMaxReadRequestOperationCount());
                followParameters.setMaxWriteRequestOperationCount(params.getMaxWriteRequestOperationCount());
                followParameters.setMaxReadRequestSize(params.getMaxReadRequestSize());
                followParameters.setMaxWriteRequestSize(params.getMaxWriteRequestSize());
                followParameters.setMaxWriteBufferCount(params.getMaxWriteBufferCount());
                followParameters.setMaxWriteBufferSize(params.getMaxWriteBufferSize());
                followParameters.setMaxRetryDelay(params.getMaxRetryDelay());
                followParameters.setReadPollTimeout(params.getReadPollTimeout());
                followerInfos.add(new FollowInfoAction.Response.FollowerInfo(followerIndex, remoteCluster, leaderIndex, FollowInfoAction.Response.Status.ACTIVE, followParameters));
                continue;
            }
            followerInfos.add(new FollowInfoAction.Response.FollowerInfo(followerIndex, remoteCluster, leaderIndex, FollowInfoAction.Response.Status.PAUSED, null));
        }
        return followerInfos;
    }
}

