/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.support;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;

public class SamlAuthenticationState
implements Writeable,
ToXContentObject {
    @Nullable
    private String requestedNameidFormat;
    @Nullable
    private String authnRequestId;
    public static final ObjectParser<SamlAuthenticationState, SamlAuthenticationState> PARSER = new ObjectParser("saml_authn_state", true, SamlAuthenticationState::new);

    public SamlAuthenticationState() {
    }

    public SamlAuthenticationState(StreamInput in) throws IOException {
        this.requestedNameidFormat = in.readOptionalString();
        this.authnRequestId = in.readOptionalString();
    }

    public String getRequestedNameidFormat() {
        return this.requestedNameidFormat;
    }

    public void setRequestedNameidFormat(String requestedNameidFormat) {
        this.requestedNameidFormat = requestedNameidFormat;
    }

    public String getAuthnRequestId() {
        return this.authnRequestId;
    }

    public void setAuthnRequestId(String authnRequestId) {
        this.authnRequestId = authnRequestId;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Fields.NAMEID_FORMAT.getPreferredName(), this.requestedNameidFormat);
        builder.field(Fields.AUTHN_REQUEST_ID.getPreferredName(), this.authnRequestId);
        return builder.endObject();
    }

    public static SamlAuthenticationState fromXContent(XContentParser parser) throws IOException {
        SamlAuthenticationState authnState = new SamlAuthenticationState();
        return (SamlAuthenticationState)PARSER.parse(parser, (Object)authnState, null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.requestedNameidFormat);
        out.writeOptionalString(this.authnRequestId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlAuthenticationState that = (SamlAuthenticationState)o;
        return Objects.equals(this.requestedNameidFormat, that.requestedNameidFormat) && Objects.equals(this.authnRequestId, that.authnRequestId);
    }

    public int hashCode() {
        return Objects.hash(this.requestedNameidFormat, this.authnRequestId);
    }

    static {
        PARSER.declareStringOrNull(SamlAuthenticationState::setRequestedNameidFormat, Fields.NAMEID_FORMAT);
        PARSER.declareStringOrNull(SamlAuthenticationState::setAuthnRequestId, Fields.AUTHN_REQUEST_ID);
    }

    public static interface Fields {
        public static final ParseField NAMEID_FORMAT = new ParseField("nameid_format", new String[0]);
        public static final ParseField AUTHN_REQUEST_ID = new ParseField("authn_request_id", new String[0]);
    }
}

