/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.wildcard.mapper;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.LowercaseNormalizer;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.StringBinaryIndexFieldData;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xpack.wildcard.mapper.BinaryDvConfirmedAutomatonQuery;
import org.elasticsearch.xpack.wildcard.mapper.MatchAllButRequireVerificationQuery;

public class WildcardFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "wildcard";
    public static short MAX_CLAUSES_IN_APPROXIMATION_QUERY = (short)10;
    public static final int NGRAM_SIZE = 3;
    static final NamedAnalyzer WILDCARD_ANALYZER_7_10 = new NamedAnalyzer("_wildcard_7_10", AnalyzerScope.GLOBAL, new Analyzer(){

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            NGramTokenizer tokenizer = new NGramTokenizer(3, 3);
            Object tok = new LowerCaseFilter((TokenStream)tokenizer);
            tok = new PunctuationFoldingFilter((TokenStream)tok);
            return new Analyzer.TokenStreamComponents(arg_0 -> ((Tokenizer)tokenizer).setReader(arg_0), (TokenStream)tok);
        }
    });
    @Deprecated
    static final NamedAnalyzer WILDCARD_ANALYZER_7_9 = new NamedAnalyzer("_wildcard", AnalyzerScope.GLOBAL, new Analyzer(){

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            NGramTokenizer tokenizer = new NGramTokenizer(3, 3);
            LowerCaseFilter tok = new LowerCaseFilter((TokenStream)tokenizer);
            return new Analyzer.TokenStreamComponents(arg_0 -> ((Tokenizer)tokenizer).setReader(arg_0), (TokenStream)tok);
        }
    });
    public static FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated()));
    public static final char TOKEN_START_OR_END_CHAR = '\u0000';
    public static final String TOKEN_START_STRING = Character.toString('\u0000');
    public static final String TOKEN_END_STRING = TOKEN_START_STRING + TOKEN_START_STRING;
    private final int ignoreAbove;
    private final String nullValue;
    private final FieldType ngramFieldType;
    private final Version indexVersionCreated;

    private static WildcardFieldMapper toType(FieldMapper in) {
        return (WildcardFieldMapper)in;
    }

    private WildcardFieldMapper(String simpleName, WildcardFieldType mappedFieldType, int ignoreAbove, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, String nullValue, Version indexVersionCreated) {
        super(simpleName, (MappedFieldType)mappedFieldType, mappedFieldType.analyzer, multiFields, copyTo);
        this.nullValue = nullValue;
        this.ignoreAbove = ignoreAbove;
        this.indexVersionCreated = indexVersionCreated;
        this.ngramFieldType = new FieldType((IndexableFieldType)Defaults.FIELD_TYPE);
        this.ngramFieldType.setTokenized(true);
        this.ngramFieldType.freeze();
        assert (this.ngramFieldType.indexOptions() == IndexOptions.DOCS);
    }

    int ignoreAbove() {
        return this.ignoreAbove;
    }

    public WildcardFieldType fieldType() {
        return (WildcardFieldType)super.fieldType();
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        String value = parser.currentToken() == XContentParser.Token.VALUE_NULL ? this.nullValue : parser.textOrNull();
        LuceneDocument parseDoc = context.doc();
        ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
        if (value != null) {
            if (value.length() <= this.ignoreAbove) {
                this.createFields(value, parseDoc, fields);
            } else {
                context.addIgnoredField(this.name());
            }
        }
        parseDoc.addAll(fields);
    }

    void createFields(String value, LuceneDocument parseDoc, List<IndexableField> fields) {
        String ngramValue = WildcardFieldMapper.addLineEndChars(value);
        Field ngramField = new Field(this.fieldType().name(), (CharSequence)ngramValue, (IndexableFieldType)this.ngramFieldType);
        fields.add((IndexableField)ngramField);
        BinaryFieldMapper.CustomBinaryDocValuesField dvField = (BinaryFieldMapper.CustomBinaryDocValuesField)parseDoc.getByKey((Object)this.fieldType().name());
        if (dvField == null) {
            dvField = new BinaryFieldMapper.CustomBinaryDocValuesField(this.fieldType().name(), value.getBytes(StandardCharsets.UTF_8));
            parseDoc.addWithKey((Object)this.fieldType().name(), (IndexableField)dvField);
        } else {
            dvField.add(value.getBytes(StandardCharsets.UTF_8));
        }
    }

    static String addLineEndChars(String value) {
        return '\u0000' + value + '\u0000' + '\u0000';
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexVersionCreated).init(this);
    }

    public static final class WildcardFieldType
    extends MappedFieldType {
        static Analyzer lowercaseNormalizer = new LowercaseNormalizer();
        private final String nullValue;
        private final int ignoreAbove;
        private final NamedAnalyzer analyzer;

        private WildcardFieldType(String name, String nullValue, int ignoreAbove, Version version, Map<String, String> meta) {
            super(name, true, false, true, Defaults.TEXT_SEARCH_INFO, meta);
            this.analyzer = version.onOrAfter(Version.V_7_10_0) ? WILDCARD_ANALYZER_7_10 : WILDCARD_ANALYZER_7_9;
            this.nullValue = nullValue;
            this.ignoreAbove = ignoreAbove;
        }

        public Query normalizedWildcardQuery(String value, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            return this.wildcardQuery(value, method, false, context);
        }

        public Query wildcardQuery(String wildcardPattern, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            Automaton automaton;
            int length;
            String ngramIndexPattern = WildcardFieldMapper.addLineEndChars(wildcardPattern);
            LinkedHashSet<String> tokens = new LinkedHashSet<String>();
            StringBuilder sequence = new StringBuilder();
            int numWildcardChars = 0;
            int numWildcardStrings = 0;
            block5: for (int i = 0; i < ngramIndexPattern.length(); i += length) {
                int c = ngramIndexPattern.codePointAt(i);
                length = Character.charCount(c);
                switch (c) {
                    case 42: {
                        if (sequence.length() > 0) {
                            this.getNgramTokens(tokens, sequence.toString());
                            sequence = new StringBuilder();
                        }
                        ++numWildcardStrings;
                        continue block5;
                    }
                    case 63: {
                        if (sequence.length() > 0) {
                            this.getNgramTokens(tokens, sequence.toString());
                            sequence = new StringBuilder();
                        }
                        ++numWildcardChars;
                        continue block5;
                    }
                    case 92: {
                        if (i + length < ngramIndexPattern.length()) {
                            int nextChar = ngramIndexPattern.codePointAt(i + length);
                            length += Character.charCount(nextChar);
                            sequence.append(Character.toChars(nextChar));
                            continue block5;
                        }
                        sequence.append(Character.toChars(c));
                        continue block5;
                    }
                    default: {
                        sequence.append(Character.toChars(c));
                    }
                }
            }
            if (sequence.length() > 0) {
                this.getNgramTokens(tokens, sequence.toString());
            }
            BooleanQuery.Builder rewritten = new BooleanQuery.Builder();
            int clauseCount = 0;
            for (String string : tokens) {
                if (clauseCount >= MAX_CLAUSES_IN_APPROXIMATION_QUERY) break;
                this.addClause(string, rewritten, BooleanClause.Occur.MUST);
                ++clauseCount;
            }
            Automaton automaton2 = automaton = caseInsensitive ? AutomatonQueries.toCaseInsensitiveWildcardAutomaton((Term)new Term(this.name(), wildcardPattern), (int)Integer.MAX_VALUE) : WildcardQuery.toAutomaton((Term)new Term(this.name(), wildcardPattern));
            if (clauseCount > 0) {
                BooleanQuery approxQuery = rewritten.build();
                return new BinaryDvConfirmedAutomatonQuery((Query)approxQuery, this.name(), wildcardPattern, automaton);
            }
            if (numWildcardChars == 0 || numWildcardStrings > 0) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new BinaryDvConfirmedAutomatonQuery((Query)new MatchAllDocsQuery(), this.name(), wildcardPattern, automaton);
        }

        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            if (value.length() == 0) {
                return new MatchNoDocsQuery();
            }
            RegExp ngramRegex = new RegExp(WildcardFieldMapper.addLineEndChars(value), syntaxFlags, matchFlags);
            Query approxBooleanQuery = WildcardFieldType.toApproximationQuery(ngramRegex);
            Query approxNgramQuery = this.rewriteBoolToNgramQuery(approxBooleanQuery);
            if (approxNgramQuery instanceof MatchAllDocsQuery) {
                return this.existsQuery(context);
            }
            RegExp regex = new RegExp(value, syntaxFlags, matchFlags);
            Automaton automaton = regex.toAutomaton(maxDeterminizedStates);
            if (approxNgramQuery instanceof MatchAllButRequireVerificationQuery) {
                return new BinaryDvConfirmedAutomatonQuery((Query)new MatchAllDocsQuery(), this.name(), value, automaton);
            }
            return new BinaryDvConfirmedAutomatonQuery(approxNgramQuery, this.name(), value, automaton);
        }

        public static Query toApproximationQuery(RegExp r) throws IllegalArgumentException {
            Query result = null;
            switch (r.kind) {
                case REGEXP_UNION: {
                    result = WildcardFieldType.createUnionQuery(r);
                    break;
                }
                case REGEXP_CONCATENATION: {
                    result = WildcardFieldType.createConcatenationQuery(r);
                    break;
                }
                case REGEXP_STRING: {
                    String normalizedString = WildcardFieldType.toLowerCase(r.s);
                    result = new TermQuery(new Term("", normalizedString));
                    break;
                }
                case REGEXP_CHAR: {
                    String cs = new StringBuilder().appendCodePoint(r.c).toString();
                    String normalizedChar = WildcardFieldType.toLowerCase(cs);
                    result = new TermQuery(new Term("", normalizedChar));
                    break;
                }
                case REGEXP_REPEAT: {
                    result = new MatchAllDocsQuery();
                    break;
                }
                case REGEXP_REPEAT_MIN: 
                case REGEXP_REPEAT_MINMAX: {
                    if (r.min > 0) {
                        result = WildcardFieldType.toApproximationQuery(r.exp1);
                        if (!(result instanceof TermQuery)) break;
                        BooleanQuery.Builder wrapper = new BooleanQuery.Builder();
                        wrapper.add(result, BooleanClause.Occur.MUST);
                        result = wrapper.build();
                        break;
                    }
                    result = new MatchAllButRequireVerificationQuery();
                    break;
                }
                case REGEXP_ANYSTRING: {
                    result = new MatchAllDocsQuery();
                    break;
                }
                case REGEXP_OPTIONAL: 
                case REGEXP_INTERSECTION: 
                case REGEXP_COMPLEMENT: 
                case REGEXP_CHAR_RANGE: 
                case REGEXP_ANYCHAR: 
                case REGEXP_INTERVAL: 
                case REGEXP_EMPTY: 
                case REGEXP_AUTOMATON: {
                    result = new MatchAllButRequireVerificationQuery();
                }
            }
            assert (result != null);
            return result;
        }

        private static Query createConcatenationQuery(RegExp r) {
            BooleanQuery combined;
            ArrayList<Query> queries = new ArrayList<Query>();
            WildcardFieldType.findLeaves(r.exp1, RegExp.Kind.REGEXP_CONCATENATION, queries);
            WildcardFieldType.findLeaves(r.exp2, RegExp.Kind.REGEXP_CONCATENATION, queries);
            BooleanQuery.Builder bAnd = new BooleanQuery.Builder();
            StringBuilder sequence = new StringBuilder();
            for (Query query : queries) {
                if (query instanceof TermQuery) {
                    TermQuery tq = (TermQuery)query;
                    sequence.append(tq.getTerm().text());
                    continue;
                }
                if (sequence.length() > 0) {
                    bAnd.add((Query)new TermQuery(new Term("", sequence.toString())), BooleanClause.Occur.MUST);
                    sequence = new StringBuilder();
                }
                bAnd.add(query, BooleanClause.Occur.MUST);
            }
            if (sequence.length() > 0) {
                bAnd.add((Query)new TermQuery(new Term("", sequence.toString())), BooleanClause.Occur.MUST);
            }
            if ((combined = bAnd.build()).clauses().size() > 0) {
                return combined;
            }
            return new MatchAllButRequireVerificationQuery();
        }

        private static Query createUnionQuery(RegExp r) {
            ArrayList<Query> queries = new ArrayList<Query>();
            WildcardFieldType.findLeaves(r.exp1, RegExp.Kind.REGEXP_UNION, queries);
            WildcardFieldType.findLeaves(r.exp2, RegExp.Kind.REGEXP_UNION, queries);
            BooleanQuery.Builder bOr = new BooleanQuery.Builder();
            HashSet<Query> uniqueClauses = new HashSet<Query>();
            for (Query query : queries) {
                if (!uniqueClauses.add(query)) continue;
                bOr.add(query, BooleanClause.Occur.SHOULD);
            }
            if (uniqueClauses.size() > 0) {
                if (uniqueClauses.size() == 1) {
                    return (Query)uniqueClauses.iterator().next();
                }
                return bOr.build();
            }
            return new MatchAllButRequireVerificationQuery();
        }

        private static void findLeaves(RegExp exp, RegExp.Kind kind, List<Query> queries) {
            if (exp.kind == kind) {
                WildcardFieldType.findLeaves(exp.exp1, kind, queries);
                WildcardFieldType.findLeaves(exp.exp2, kind, queries);
            } else {
                queries.add(WildcardFieldType.toApproximationQuery(exp));
            }
        }

        private static String toLowerCase(String string) {
            return lowercaseNormalizer.normalize(null, string).utf8ToString();
        }

        private Query rewriteBoolToNgramQuery(Query approxQuery) {
            if (approxQuery == null) {
                return null;
            }
            if (approxQuery instanceof BooleanQuery) {
                BooleanQuery bq = (BooleanQuery)approxQuery;
                BooleanQuery.Builder rewritten = new BooleanQuery.Builder();
                short clauseCount = 0;
                for (BooleanClause clause : bq) {
                    Query q = this.rewriteBoolToNgramQuery(clause.getQuery());
                    if (q == null) continue;
                    if (clause.getOccur().equals((Object)BooleanClause.Occur.MUST) && ++clauseCount >= MAX_CLAUSES_IN_APPROXIMATION_QUERY) break;
                    rewritten.add(q, clause.getOccur());
                }
                return WildcardFieldType.simplify((Query)rewritten.build());
            }
            if (approxQuery instanceof TermQuery) {
                TermQuery tq = (TermQuery)approxQuery;
                String s = tq.getTerm().text();
                if (s.equals(TOKEN_START_STRING) || s.equals(TOKEN_END_STRING)) {
                    return new MatchAllButRequireVerificationQuery();
                }
                LinkedHashSet<String> tokens = new LinkedHashSet<String>();
                this.getNgramTokens(tokens, s);
                BooleanQuery.Builder rewritten = new BooleanQuery.Builder();
                for (String string : tokens) {
                    this.addClause(string, rewritten, BooleanClause.Occur.MUST);
                }
                return WildcardFieldType.simplify((Query)rewritten.build());
            }
            if (WildcardFieldType.isMatchAll(approxQuery)) {
                return approxQuery;
            }
            throw new IllegalStateException("Invalid query type found parsing regex query:" + approxQuery);
        }

        static Query simplify(Query input) {
            if (!(input instanceof BooleanQuery)) {
                return input;
            }
            BooleanQuery result = (BooleanQuery)input;
            if (result.clauses().size() == 0) {
                return new MatchAllDocsQuery();
            }
            if (result.clauses().size() == 1) {
                return WildcardFieldType.simplify(((BooleanClause)result.clauses().get(0)).getQuery());
            }
            int matchAllCount = 0;
            int verifyCount = 0;
            boolean allConcretesAreOptional = true;
            for (BooleanClause booleanClause : result.clauses()) {
                Query q = booleanClause.getQuery();
                if (q instanceof MatchAllDocsQuery) {
                    ++matchAllCount;
                    continue;
                }
                if (q instanceof MatchAllButRequireVerificationQuery) {
                    ++verifyCount;
                    continue;
                }
                if (booleanClause.getOccur() == BooleanClause.Occur.SHOULD) continue;
                allConcretesAreOptional = false;
            }
            if (allConcretesAreOptional && matchAllCount > 0) {
                return new MatchAllDocsQuery();
            }
            if (allConcretesAreOptional && verifyCount > 0) {
                return new MatchAllButRequireVerificationQuery();
            }
            if (!allConcretesAreOptional && matchAllCount + verifyCount > 0) {
                BooleanQuery.Builder rewritten = new BooleanQuery.Builder();
                for (BooleanClause booleanClause : result.clauses()) {
                    if (WildcardFieldType.isMatchAll(booleanClause.getQuery())) continue;
                    rewritten.add(booleanClause);
                }
                return WildcardFieldType.simplify((Query)rewritten.build());
            }
            return result;
        }

        static boolean isMatchAll(Query q) {
            return q instanceof MatchAllDocsQuery || q instanceof MatchAllButRequireVerificationQuery;
        }

        protected void getNgramTokens(Set<String> tokens, String fragment) {
            if (fragment.equals(TOKEN_START_STRING) || fragment.equals(TOKEN_END_STRING)) {
                return;
            }
            TokenStream tokenizer = this.analyzer.tokenStream(this.name(), fragment);
            CharTermAttribute termAtt = (CharTermAttribute)tokenizer.addAttribute(CharTermAttribute.class);
            int foundTokens = 0;
            try {
                tokenizer.reset();
                while (tokenizer.incrementToken()) {
                    String tokenValue = termAtt.toString();
                    tokens.add(tokenValue);
                    ++foundTokens;
                }
                tokenizer.end();
                tokenizer.close();
            }
            catch (IOException ioe) {
                throw new ElasticsearchParseException("Error parsing wildcard regex pattern fragment [" + fragment + "]", new Object[0]);
            }
            if (foundTokens == 0 && fragment.length() > 0) {
                fragment = WildcardFieldType.toLowerCase(fragment);
                if (this.analyzer == WILDCARD_ANALYZER_7_10) {
                    fragment = PunctuationFoldingFilter.normalize(fragment);
                }
                tokens.add(fragment);
            }
        }

        private void addClause(String token, BooleanQuery.Builder bqBuilder, BooleanClause.Occur occur) {
            assert (token.codePointCount(0, token.length()) <= 3);
            int tokenSize = token.codePointCount(0, token.length());
            if (tokenSize < 2 || token.equals(TOKEN_END_STRING)) {
                bqBuilder.add(new BooleanClause((Query)new MatchAllButRequireVerificationQuery(), occur));
                return;
            }
            if (tokenSize == 3) {
                TermQuery tq = new TermQuery(new Term(this.name(), token));
                bqBuilder.add(new BooleanClause((Query)tq, occur));
            } else {
                PrefixQuery wq = new PrefixQuery(new Term(this.name(), token));
                wq.setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_REWRITE);
                bqBuilder.add(new BooleanClause((Query)wq, occur));
            }
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
            BytesRef lower = lowerTerm == null ? null : BytesRefs.toBytesRef((Object)lowerTerm);
            BytesRef upper = upperTerm == null ? null : BytesRefs.toBytesRef((Object)upperTerm);
            BooleanQuery accelerationQuery = null;
            if (lowerTerm != null && upperTerm != null) {
                int cU;
                int cL;
                int length;
                StringBuilder commonPrefix = new StringBuilder();
                String lowerS = WildcardFieldMapper.addLineEndChars(lower.utf8ToString());
                String upperS = WildcardFieldMapper.addLineEndChars(upper.utf8ToString());
                for (int i = 0; i < Math.min(lowerS.length(), upperS.length()) && (cL = lowerS.codePointAt(i)) == (cU = upperS.codePointAt(i)); i += length) {
                    commonPrefix.append(Character.toChars(cL));
                    length = Character.charCount(cL);
                }
                if (commonPrefix.length() > 0) {
                    HashSet<String> tokens = new HashSet<String>();
                    this.getNgramTokens(tokens, commonPrefix.toString());
                    BooleanQuery.Builder bqBuilder = new BooleanQuery.Builder();
                    for (String token : tokens) {
                        int tokenSize = token.codePointCount(0, token.length());
                        if (tokenSize < 2 || token.equals(TOKEN_END_STRING)) continue;
                        if (tokenSize == 3) {
                            TermQuery tq = new TermQuery(new Term(this.name(), token));
                            bqBuilder.add(new BooleanClause((Query)tq, BooleanClause.Occur.MUST));
                            continue;
                        }
                        PrefixQuery wq = new PrefixQuery(new Term(this.name(), token));
                        wq.setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_REWRITE);
                        bqBuilder.add(new BooleanClause((Query)wq, BooleanClause.Occur.MUST));
                    }
                    BooleanQuery bq = bqBuilder.build();
                    if (bq.clauses().size() > 0) {
                        accelerationQuery = bq;
                    }
                }
            }
            Automaton automaton = TermRangeQuery.toAutomaton((BytesRef)lower, (BytesRef)upper, (boolean)includeLower, (boolean)includeUpper);
            if (accelerationQuery == null) {
                return new BinaryDvConfirmedAutomatonQuery((Query)new MatchAllDocsQuery(), this.name(), lower + "-" + upper, automaton);
            }
            return new BinaryDvConfirmedAutomatonQuery((Query)accelerationQuery, this.name(), lower + "-" + upper, automaton);
        }

        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context) {
            String searchTerm = BytesRefs.toString((Object)value);
            try {
                BooleanQuery.Builder approxBuilder = new BooleanQuery.Builder();
                String postPrefixString = searchTerm;
                if (prefixLength > 0) {
                    LinkedHashSet<String> prefixTokens = new LinkedHashSet<String>();
                    postPrefixString = searchTerm.substring(prefixLength);
                    String prefixCandidate = '\u0000' + searchTerm.substring(0, prefixLength);
                    this.getNgramTokens(prefixTokens, prefixCandidate);
                    for (String prefixToken : prefixTokens) {
                        this.addClause(prefixToken, approxBuilder, BooleanClause.Occur.MUST);
                    }
                }
                TokenStream tokenizer = this.analyzer.tokenStream(this.name(), postPrefixString);
                CharTermAttribute termAtt = (CharTermAttribute)tokenizer.addAttribute(CharTermAttribute.class);
                ArrayList<String> postPrefixTokens = new ArrayList<String>();
                String firstToken = null;
                tokenizer.reset();
                int tokenNumber = 0;
                while (tokenizer.incrementToken()) {
                    if (tokenNumber == 0) {
                        String token = termAtt.toString();
                        if (firstToken == null) {
                            firstToken = token;
                        }
                        postPrefixTokens.add(token);
                    }
                    if (++tokenNumber != 3) continue;
                    tokenNumber = 0;
                }
                tokenizer.end();
                tokenizer.close();
                BooleanQuery.Builder ngramBuilder = new BooleanQuery.Builder();
                int numClauses = 0;
                for (String token : postPrefixTokens) {
                    this.addClause(token, ngramBuilder, BooleanClause.Occur.SHOULD);
                    ++numClauses;
                }
                if (numClauses > fuzziness.asDistance(searchTerm)) {
                    ngramBuilder.setMinimumNumberShouldMatch(numClauses - fuzziness.asDistance(searchTerm));
                    approxBuilder.add((Query)ngramBuilder.build(), BooleanClause.Occur.MUST);
                }
                BooleanQuery ngramQ = approxBuilder.build();
                FuzzyQuery fq = new FuzzyQuery(new Term(this.name(), searchTerm), fuzziness.asDistance(searchTerm), prefixLength, maxExpansions, transpositions);
                if (ngramQ.clauses().size() == 0) {
                    return new BinaryDvConfirmedAutomatonQuery((Query)new MatchAllDocsQuery(), this.name(), searchTerm, fq.getAutomata().automaton);
                }
                return new BinaryDvConfirmedAutomatonQuery((Query)ngramQ, this.name(), searchTerm, fq.getAutomata().automaton);
            }
            catch (IOException ioe) {
                throw new ElasticsearchParseException("Error parsing wildcard field fuzzy string [" + searchTerm + "]", new Object[0]);
            }
        }

        public String typeName() {
            return WildcardFieldMapper.CONTENT_TYPE;
        }

        public String familyTypeName() {
            return "keyword";
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            String searchTerm = BytesRefs.toString((Object)value);
            return this.wildcardQuery(this.escapeWildcardSyntax(searchTerm), MultiTermQuery.CONSTANT_SCORE_REWRITE, false, context);
        }

        private String escapeWildcardSyntax(String term) {
            int length;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < term.length(); i += length) {
                int c = term.codePointAt(i);
                length = Character.charCount(c);
                if (c == 42 || c == 63 || c == 92) {
                    result.append("\\");
                }
                result.appendCodePoint(c);
            }
            return result.toString();
        }

        public Query termQueryCaseInsensitive(Object value, SearchExecutionContext context) {
            String searchTerm = BytesRefs.toString((Object)value);
            return this.wildcardQuery(this.escapeWildcardSyntax(searchTerm), MultiTermQuery.CONSTANT_SCORE_REWRITE, true, context);
        }

        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            return this.wildcardQuery(this.escapeWildcardSyntax(value) + "*", method, caseInsensitive, context);
        }

        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            for (Object value : values) {
                bq.add(this.termQuery(value, context), BooleanClause.Occur.SHOULD);
            }
            return new ConstantScoreQuery((Query)bq.build());
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return (cache, breakerService) -> new StringBinaryIndexFieldData(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD);
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                protected String parseSourceValue(Object value) {
                    String keywordValue = value.toString();
                    if (keywordValue.length() > ignoreAbove) {
                        return null;
                    }
                    return keywordValue;
                }
            };
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final TextSearchInfo TEXT_SEARCH_INFO;
        public static final int IGNORE_ABOVE = Integer.MAX_VALUE;

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setStoreTermVectorOffsets(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
            TEXT_SEARCH_INFO = new TextSearchInfo(FIELD_TYPE, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Integer> ignoreAbove = FieldMapper.Parameter.intParam((String)"ignore_above", (boolean)true, m -> WildcardFieldMapper.access$400(WildcardFieldMapper.toType(m)), (int)Integer.MAX_VALUE).setValidator(v -> {
            if (v < 0) {
                throw new IllegalArgumentException("[ignore_above] must be positive, got [" + v + "]");
            }
        });
        final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam((String)"null_value", (boolean)false, m -> WildcardFieldMapper.access$300(WildcardFieldMapper.toType(m)), null).acceptsNull();
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        final Version indexVersionCreated;

        public Builder(String name, Version indexVersionCreated) {
            super(name);
            this.indexVersionCreated = indexVersionCreated;
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.ignoreAbove, this.nullValue, this.meta);
        }

        Builder ignoreAbove(int ignoreAbove) {
            this.ignoreAbove.setValue((Object)ignoreAbove);
            return this;
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue((Object)nullValue);
            return this;
        }

        public WildcardFieldMapper build(ContentPath contentPath) {
            return new WildcardFieldMapper(this.name, new WildcardFieldType(this.buildFullName(contentPath), (String)this.nullValue.get(), (Integer)this.ignoreAbove.get(), this.indexVersionCreated, (Map)this.meta.get()), (Integer)this.ignoreAbove.get(), this.multiFieldsBuilder.build((Mapper.Builder)this, contentPath), this.copyTo.build(), (String)this.nullValue.get(), this.indexVersionCreated);
        }
    }

    public static class PunctuationFoldingFilter
    extends TokenFilter {
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

        public PunctuationFoldingFilter(TokenStream in) {
            super(in);
        }

        public final boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                PunctuationFoldingFilter.normalize(this.termAtt.buffer(), 0, this.termAtt.length());
                return true;
            }
            return false;
        }

        public static String normalize(String s) {
            char[] chars = s.toCharArray();
            PunctuationFoldingFilter.normalize(chars, 0, chars.length);
            return new String(chars);
        }

        public static void normalize(char[] buffer, int offset, int limit) {
            int codepoint;
            assert (buffer.length >= limit);
            assert (0 <= offset && offset <= buffer.length);
            for (int i = offset; i < limit; i += Character.toChars(PunctuationFoldingFilter.normalize(codepoint), buffer, i)) {
                codepoint = Character.codePointAt(buffer, i, limit);
            }
        }

        private static int normalize(int codepoint) {
            if (codepoint == 0) {
                return codepoint;
            }
            if (!Character.isLetterOrDigit(codepoint)) {
                return 47;
            }
            if (codepoint > 48 && codepoint <= 128 && codepoint % 2 == 0) {
                return codepoint - 1;
            }
            return codepoint;
        }
    }
}

