/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.function.scalar.string;

import java.util.Arrays;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.string.CaseInsensitiveScalarFunction;
import org.elasticsearch.xpack.ql.expression.function.scalar.string.StartsWithFunctionPipe;
import org.elasticsearch.xpack.ql.expression.function.scalar.string.StartsWithFunctionProcessor;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public abstract class StartsWith
extends CaseInsensitiveScalarFunction {
    private final Expression input;
    private final Expression pattern;

    public StartsWith(Source source, Expression input, Expression pattern, boolean caseInsensitive) {
        super(source, Arrays.asList(input, pattern), caseInsensitive);
        this.input = input;
        this.pattern = pattern;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution fieldResolution = TypeResolutions.isStringAndExact(this.input, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST);
        if (fieldResolution.unresolved()) {
            return fieldResolution;
        }
        return TypeResolutions.isStringAndExact(this.pattern, this.sourceText(), TypeResolutions.ParamOrdinal.SECOND);
    }

    public Expression input() {
        return this.input;
    }

    public Expression pattern() {
        return this.pattern;
    }

    @Override
    public Pipe makePipe() {
        return new StartsWithFunctionPipe(this.source(), this, Expressions.pipe(this.input), Expressions.pipe(this.pattern), this.isCaseInsensitive());
    }

    @Override
    public boolean foldable() {
        return this.input.foldable() && this.pattern.foldable();
    }

    @Override
    public Object fold() {
        return StartsWithFunctionProcessor.doProcess(this.input.fold(), this.pattern.fold(), this.isCaseInsensitive());
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate fieldScript = this.asScript(this.input);
        ScriptTemplate patternScript = this.asScript(this.pattern);
        return this.asScriptFrom(fieldScript, patternScript);
    }

    protected ScriptTemplate asScriptFrom(ScriptTemplate fieldScript, ScriptTemplate patternScript) {
        ParamsBuilder params = ParamsBuilder.paramsBuilder();
        String template = this.formatTemplate("{ql}.startsWith(" + fieldScript.template() + ", " + patternScript.template() + ", {})");
        params.script(fieldScript.params()).script(patternScript.params()).variable(this.isCaseInsensitive());
        return new ScriptTemplate(template, params.build(), this.dataType());
    }

    @Override
    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable(field.exactAttribute().name()).build(), this.dataType());
    }

    @Override
    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }
}

