/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.Params;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogicPipe;
import org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogicProcessor;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparisonPipe;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparisonProcessor;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Range
extends ScalarFunction {
    private final Expression value;
    private final Expression lower;
    private final Expression upper;
    private final boolean includeLower;
    private final boolean includeUpper;
    private final ZoneId zoneId;

    public Range(Source src, Expression value, Expression lower, boolean inclLower, Expression upper, boolean inclUpper, ZoneId zoneId) {
        super(src, Arrays.asList(value, lower, upper));
        this.value = value;
        this.lower = lower;
        this.upper = upper;
        this.includeLower = inclLower;
        this.includeUpper = inclUpper;
        this.zoneId = zoneId;
    }

    @Override
    protected NodeInfo<Range> info() {
        return NodeInfo.create(this, Range::new, this.value, this.lower, this.includeLower, this.upper, this.includeUpper, this.zoneId);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Range(this.source(), newChildren.get(0), newChildren.get(1), this.includeLower, newChildren.get(2), this.includeUpper, this.zoneId);
    }

    public Expression value() {
        return this.value;
    }

    public Expression lower() {
        return this.lower;
    }

    public Expression upper() {
        return this.upper;
    }

    public boolean includeLower() {
        return this.includeLower;
    }

    public boolean includeUpper() {
        return this.includeUpper;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    @Override
    public boolean foldable() {
        if (this.lower.foldable() && this.upper.foldable()) {
            return this.areBoundariesInvalid() || this.value.foldable();
        }
        return false;
    }

    @Override
    public Object fold() {
        boolean lowerComparsion;
        if (this.areBoundariesInvalid()) {
            return Boolean.FALSE;
        }
        Object val = this.value.fold();
        Integer lowerCompare = BinaryComparison.compare(this.lower.fold(), val);
        Integer upperCompare = BinaryComparison.compare(val, this.upper().fold());
        boolean bl = lowerCompare == null ? false : (this.includeLower ? lowerCompare <= 0 : (lowerComparsion = lowerCompare < 0));
        boolean upperComparsion = upperCompare == null ? false : (this.includeUpper ? upperCompare <= 0 : upperCompare < 0);
        return lowerComparsion && upperComparsion;
    }

    private boolean areBoundariesInvalid() {
        Integer compare = BinaryComparison.compare(this.lower.fold(), this.upper.fold());
        return compare != null && (compare > 0 || compare == 0 && (!this.includeLower || !this.includeUpper));
    }

    @Override
    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate valueScript = this.asScript(this.value);
        ScriptTemplate lowerScript = this.asScript(this.lower);
        ScriptTemplate upperScript = this.asScript(this.upper);
        String template = this.formatTemplate(String.format(Locale.ROOT, "{ql}.and({ql}.%s(%s, %s), {ql}.%s(%s, %s))", this.includeLower() ? "gte" : "gt", valueScript.template(), lowerScript.template(), this.includeUpper() ? "lte" : "lt", valueScript.template(), upperScript.template()));
        Params params = ParamsBuilder.paramsBuilder().script(valueScript.params()).script(lowerScript.params()).script(valueScript.params()).script(upperScript.params()).build();
        return new ScriptTemplate(template, params, DataTypes.BOOLEAN);
    }

    @Override
    protected Pipe makePipe() {
        BinaryComparisonPipe lowerPipe = new BinaryComparisonPipe(this.source(), this, Expressions.pipe(this.value()), Expressions.pipe(this.lower()), this.includeLower() ? BinaryComparisonProcessor.BinaryComparisonOperation.GTE : BinaryComparisonProcessor.BinaryComparisonOperation.GT);
        BinaryComparisonPipe upperPipe = new BinaryComparisonPipe(this.source(), this, Expressions.pipe(this.value()), Expressions.pipe(this.upper()), this.includeUpper() ? BinaryComparisonProcessor.BinaryComparisonOperation.LTE : BinaryComparisonProcessor.BinaryComparisonOperation.LT);
        BinaryLogicPipe and = new BinaryLogicPipe(this.source(), this, lowerPipe, upperPipe, BinaryLogicProcessor.BinaryLogicOperation.AND);
        return and;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.includeLower, this.includeUpper, this.value, this.lower, this.upper, this.zoneId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        return Objects.equals(this.includeLower, other.includeLower) && Objects.equals(this.includeUpper, other.includeUpper) && Objects.equals(this.value, other.value) && Objects.equals(this.lower, other.lower) && Objects.equals(this.upper, other.upper) && Objects.equals(this.zoneId, other.zoneId);
    }
}

