/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.querydsl.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.xpack.ql.expression.predicate.fulltext.StringQueryPredicate;
import org.elasticsearch.xpack.ql.querydsl.query.LeafQuery;
import org.elasticsearch.xpack.ql.tree.Source;

public class QueryStringQuery
extends LeafQuery {
    private static final Map<String, BiConsumer<QueryStringQueryBuilder, String>> BUILDER_APPLIERS;
    private final String query;
    private final Map<String, Float> fields;
    private StringQueryPredicate predicate;
    private final Map<String, String> options;

    public QueryStringQuery(Source source, String query, String fieldName) {
        this(source, query, Collections.singletonMap(fieldName, Float.valueOf(1.0f)), null);
    }

    public QueryStringQuery(Source source, String query, Map<String, Float> fields, StringQueryPredicate predicate) {
        super(source);
        this.query = query;
        this.fields = fields;
        this.predicate = predicate;
        this.options = predicate == null ? Collections.emptyMap() : predicate.optionMap();
    }

    @Override
    public QueryBuilder asBuilder() {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)this.query);
        queryBuilder.fields(this.fields);
        this.options.forEach((k, v) -> {
            if (!BUILDER_APPLIERS.containsKey(k)) {
                throw new IllegalArgumentException("illegal query_string option [" + k + "]");
            }
            BUILDER_APPLIERS.get(k).accept(queryBuilder, (String)v);
        });
        return queryBuilder;
    }

    public Map<String, Float> fields() {
        return this.fields;
    }

    public String query() {
        return this.query;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.query, this.fields, this.predicate);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryStringQuery other = (QueryStringQuery)obj;
        return Objects.equals(this.query, other.query) && Objects.equals(this.fields, other.fields) && Objects.equals(this.predicate, other.predicate);
    }

    @Override
    protected String innerToString() {
        return this.fields + ":" + this.query;
    }

    static {
        HashMap<String, BiConsumer<QueryStringQueryBuilder, String>> appliers = new HashMap<String, BiConsumer<QueryStringQueryBuilder, String>>(28);
        appliers.put("allow_leading_wildcard", (qb, s) -> qb.allowLeadingWildcard(Boolean.valueOf(Booleans.parseBoolean((String)s))));
        appliers.put("analyze_wildcard", (qb, s) -> qb.analyzeWildcard(Boolean.valueOf(Booleans.parseBoolean((String)s))));
        appliers.put("analyzer", (qb, s) -> qb.analyzer(s));
        appliers.put("auto_generate_synonyms_phrase_query", (qb, s) -> qb.autoGenerateSynonymsPhraseQuery(Booleans.parseBoolean((String)s)));
        appliers.put("default_field", (qb, s) -> qb.defaultField(s));
        appliers.put("default_operator", (qb, s) -> qb.defaultOperator(Operator.fromString((String)s)));
        appliers.put("enable_position_increments", (qb, s) -> qb.enablePositionIncrements(Booleans.parseBoolean((String)s)));
        appliers.put("escape", (qb, s) -> qb.escape(Booleans.parseBoolean((String)s)));
        appliers.put("fuzziness", (qb, s) -> qb.fuzziness(Fuzziness.build((Object)s)));
        appliers.put("fuzzy_max_expansions", (qb, s) -> qb.fuzzyMaxExpansions(Integer.valueOf(s).intValue()));
        appliers.put("fuzzy_prefix_length", (qb, s) -> qb.fuzzyPrefixLength(Integer.valueOf(s).intValue()));
        appliers.put("fuzzy_rewrite", (qb, s) -> qb.fuzzyRewrite(s));
        appliers.put("fuzzy_transpositions", (qb, s) -> qb.fuzzyTranspositions(Booleans.parseBoolean((String)s)));
        appliers.put("lenient", (qb, s) -> qb.lenient(Boolean.valueOf(Booleans.parseBoolean((String)s))));
        appliers.put("max_determinized_states", (qb, s) -> qb.maxDeterminizedStates(Integer.valueOf(s).intValue()));
        appliers.put("minimum_should_match", (qb, s) -> qb.minimumShouldMatch(s));
        appliers.put("phrase_slop", (qb, s) -> qb.phraseSlop(Integer.valueOf(s).intValue()));
        appliers.put("rewrite", (qb, s) -> qb.rewrite(s));
        appliers.put("quote_analyzer", (qb, s) -> qb.quoteAnalyzer(s));
        appliers.put("quote_field_suffix", (qb, s) -> qb.quoteFieldSuffix(s));
        appliers.put("tie_breaker", (qb, s) -> qb.tieBreaker(Float.valueOf(s).floatValue()));
        appliers.put("time_zone", (qb, s) -> qb.timeZone(s));
        appliers.put("type", (qb, s) -> qb.type(MultiMatchQueryBuilder.Type.parse((String)s, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)));
        BUILDER_APPLIERS = Collections.unmodifiableMap(appliers);
    }
}

