/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.mapper;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ArraySourceValueFetcher;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xpack.vectors.query.VectorIndexFieldData;

public class DenseVectorFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "dense_vector";
    public static short MAX_DIMS_COUNT = (short)2048;
    private static final byte INT_BYTES = 4;
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated()), DenseVectorFieldMapper.notInMultiFields((String)"dense_vector"));
    private final Version indexCreatedVersion;
    private final int dims;

    private static DenseVectorFieldMapper toType(FieldMapper in) {
        return (DenseVectorFieldMapper)in;
    }

    private DenseVectorFieldMapper(String simpleName, MappedFieldType mappedFieldType, int dims, Version indexCreatedVersion, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.indexCreatedVersion = indexCreatedVersion;
        this.dims = dims;
    }

    public DenseVectorFieldType fieldType() {
        return (DenseVectorFieldType)super.fieldType();
    }

    public boolean parsesArrayValue() {
        return true;
    }

    public void parse(DocumentParserContext context) throws IOException {
        int dims = this.fieldType().dims();
        byte[] bytes = this.indexCreatedVersion.onOrAfter(Version.V_7_5_0) ? new byte[dims * 4 + 4] : new byte[dims * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        double dotProduct = 0.0;
        int dim = 0;
        XContentParser.Token token = context.parser().nextToken();
        while (token != XContentParser.Token.END_ARRAY) {
            if (dim++ >= dims) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] of doc [" + context.sourceToParse().id() + "] has exceeded the number of dimensions [" + dims + "] defined in mapping");
            }
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)context.parser());
            float value = context.parser().floatValue(true);
            byteBuffer.putFloat(value);
            dotProduct += (double)(value * value);
            token = context.parser().nextToken();
        }
        if (dim != dims) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] of doc [" + context.sourceToParse().id() + "] has number of dimensions [" + dim + "] less than defined in the mapping [" + dims + "]");
        }
        if (this.indexCreatedVersion.onOrAfter(Version.V_7_5_0)) {
            float vectorMagnitude = (float)Math.sqrt(dotProduct);
            byteBuffer.putFloat(vectorMagnitude);
        }
        BinaryDocValuesField field = new BinaryDocValuesField(this.fieldType().name(), new BytesRef(bytes));
        if (context.doc().getByKey((Object)this.fieldType().name()) != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't not support indexing multiple values for the same field in the same document");
        }
        context.doc().addWithKey((Object)this.fieldType().name(), (IndexableField)field);
    }

    protected void parseCreateField(DocumentParserContext context) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexCreatedVersion).init(this);
    }

    public static final class DenseVectorFieldType
    extends MappedFieldType {
        private final int dims;
        private final Version indexVersionCreated;

        public DenseVectorFieldType(String name, Version indexVersionCreated, int dims, Map<String, String> meta) {
            super(name, false, false, true, TextSearchInfo.NONE, meta);
            this.dims = dims;
            this.indexVersionCreated = indexVersionCreated;
        }

        int dims() {
            return this.dims;
        }

        public String typeName() {
            return DenseVectorFieldMapper.CONTENT_TYPE;
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new ArraySourceValueFetcher(this.name(), context){

                protected Object parseSourceValue(Object value) {
                    return value;
                }
            };
        }

        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support docvalue_fields or aggregations");
        }

        public boolean isAggregatable() {
            return false;
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            return new VectorIndexFieldData.Builder(this.name(), true, (ValuesSourceType)CoreValuesSourceType.KEYWORD, this.indexVersionCreated, this.dims);
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support queries");
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        FieldMapper.Parameter<Integer> dims = new FieldMapper.Parameter("dims", false, () -> null, (n, c, o) -> XContentMapValues.nodeIntegerValue((Object)o), m -> DenseVectorFieldMapper.access$200(DenseVectorFieldMapper.toType(m))).setValidator(dims -> {
            if (dims == null) {
                throw new MapperParsingException("Missing required parameter [dims] for field [" + this.name + "]");
            }
            if (dims > MAX_DIMS_COUNT || dims < 1) {
                throw new MapperParsingException("The number of dimensions for field [" + this.name + "] should be in the range [1, " + MAX_DIMS_COUNT + "] but was [" + dims + "]");
            }
        });
        FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        final Version indexVersionCreated;

        public Builder(String name, Version indexVersionCreated) {
            super(name);
            this.indexVersionCreated = indexVersionCreated;
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.dims, this.meta);
        }

        public DenseVectorFieldMapper build(ContentPath contentPath) {
            return new DenseVectorFieldMapper(this.name, new DenseVectorFieldType(this.buildFullName(contentPath), this.indexVersionCreated, (Integer)this.dims.getValue(), (Map)this.meta.getValue()), (Integer)this.dims.getValue(), this.indexVersionCreated, this.multiFieldsBuilder.build((Mapper.Builder)this, contentPath), this.copyTo.build());
        }
    }
}

