/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.math;

import java.io.IOException;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.ql.expression.gen.processor.FunctionalEnumBinaryProcessor;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Arithmetics;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;

public class BinaryMathProcessor
extends FunctionalEnumBinaryProcessor<Number, Number, Number, BinaryMathOperation> {
    public static final String NAME = "mb";

    public BinaryMathProcessor(Processor left, Processor right, BinaryMathOperation operation) {
        super(left, right, (Enum)operation);
    }

    public BinaryMathProcessor(StreamInput in) throws IOException {
        super(in, i -> (BinaryMathOperation)i.readEnum(BinaryMathOperation.class));
    }

    public String getWriteableName() {
        return NAME;
    }

    protected void checkParameter(Object param) {
        if (!(param instanceof Number)) {
            throw new SqlIllegalArgumentException("A number is required; received [{}]", param);
        }
    }

    public static enum BinaryMathOperation implements BiFunction<Number, Number, Number>
    {
        ATAN2((l, r) -> Math.atan2(l.doubleValue(), r.doubleValue())),
        MOD(Arithmetics::mod),
        POWER((l, r) -> Math.pow(l.doubleValue(), r.doubleValue()));

        private final BiFunction<Number, Number, Number> process;

        private BinaryMathOperation(BiFunction<Number, Number, Number> process) {
            this.process = process;
        }

        @Override
        public final Number apply(Number left, Number right) {
            if (left == null || right == null) {
                return null;
            }
            return this.process.apply(left, right);
        }
    }
}

