/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.ql.index.IndexResolver;
import org.elasticsearch.xpack.sql.SqlFeatureSet;
import org.elasticsearch.xpack.sql.action.SqlClearCursorAction;
import org.elasticsearch.xpack.sql.action.SqlQueryAction;
import org.elasticsearch.xpack.sql.action.SqlTranslateAction;
import org.elasticsearch.xpack.sql.execution.PlanExecutor;
import org.elasticsearch.xpack.sql.plugin.RestSqlAsyncDeleteResultsAction;
import org.elasticsearch.xpack.sql.plugin.RestSqlAsyncGetResultsAction;
import org.elasticsearch.xpack.sql.plugin.RestSqlAsyncGetStatusAction;
import org.elasticsearch.xpack.sql.plugin.RestSqlClearCursorAction;
import org.elasticsearch.xpack.sql.plugin.RestSqlQueryAction;
import org.elasticsearch.xpack.sql.plugin.RestSqlStatsAction;
import org.elasticsearch.xpack.sql.plugin.RestSqlTranslateAction;
import org.elasticsearch.xpack.sql.plugin.SqlAsyncGetResultsAction;
import org.elasticsearch.xpack.sql.plugin.SqlAsyncGetStatusAction;
import org.elasticsearch.xpack.sql.plugin.SqlLicenseChecker;
import org.elasticsearch.xpack.sql.plugin.SqlStatsAction;
import org.elasticsearch.xpack.sql.plugin.TransportSqlAsyncGetResultsAction;
import org.elasticsearch.xpack.sql.plugin.TransportSqlAsyncGetStatusAction;
import org.elasticsearch.xpack.sql.plugin.TransportSqlClearCursorAction;
import org.elasticsearch.xpack.sql.plugin.TransportSqlQueryAction;
import org.elasticsearch.xpack.sql.plugin.TransportSqlStatsAction;
import org.elasticsearch.xpack.sql.plugin.TransportSqlTranslateAction;
import org.elasticsearch.xpack.sql.type.SqlDataTypeRegistry;

public class SqlPlugin
extends Plugin
implements ActionPlugin {
    private final SqlLicenseChecker sqlLicenseChecker = new SqlLicenseChecker(mode -> {
        XPackLicenseState licenseState = this.getLicenseState();
        switch (mode) {
            case JDBC: {
                if (licenseState.checkFeature(XPackLicenseState.Feature.JDBC)) break;
                throw LicenseUtils.newComplianceException((String)"jdbc");
            }
            case ODBC: {
                if (licenseState.checkFeature(XPackLicenseState.Feature.ODBC)) break;
                throw LicenseUtils.newComplianceException((String)"odbc");
            }
            case PLAIN: 
            case CLI: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SQL mode " + mode);
            }
        }
    });

    public SqlPlugin(Settings settings) {
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        return this.createComponents(client, clusterService.getClusterName().value(), namedWriteableRegistry);
    }

    Collection<Object> createComponents(Client client, String clusterName, NamedWriteableRegistry namedWriteableRegistry) {
        IndexResolver indexResolver = new IndexResolver(client, clusterName, SqlDataTypeRegistry.INSTANCE);
        return Arrays.asList(this.sqlLicenseChecker, indexResolver, new PlanExecutor(client, indexResolver, namedWriteableRegistry));
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(b -> XPackPlugin.bindFeatureSet((Binder)b, SqlFeatureSet.class));
        return modules;
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new RestSqlQueryAction(), new RestSqlTranslateAction(), new RestSqlClearCursorAction(), new RestSqlStatsAction(), new RestSqlAsyncGetResultsAction(), new RestSqlAsyncGetStatusAction(), new RestSqlAsyncDeleteResultsAction()});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)SqlQueryAction.INSTANCE, TransportSqlQueryAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SqlTranslateAction.INSTANCE, TransportSqlTranslateAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SqlClearCursorAction.INSTANCE, TransportSqlClearCursorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SqlStatsAction.INSTANCE, TransportSqlStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SqlAsyncGetResultsAction.INSTANCE, TransportSqlAsyncGetResultsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SqlAsyncGetStatusAction.INSTANCE, TransportSqlAsyncGetStatusAction.class, new Class[0]));
    }
}

