/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.Objects;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.querydsl.container.Sort;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.querydsl.agg.Agg;
import org.elasticsearch.xpack.sql.querydsl.agg.AggSource;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public abstract class GroupByKey
extends Agg {
    protected final Sort.Direction direction;

    protected GroupByKey(String id, AggSource source, Sort.Direction direction) {
        super(id, source);
        this.direction = direction == null ? Sort.Direction.ASC : direction;
    }

    public ScriptTemplate script() {
        return this.source().script();
    }

    public final CompositeValuesSourceBuilder<?> asValueSource() {
        CompositeValuesSourceBuilder<?> builder = this.createSourceBuilder();
        ScriptTemplate script = this.source().script();
        if (script != null) {
            builder.script(script.toPainless());
            if (script.outputType().isInteger()) {
                builder.userValuetypeHint(ValueType.LONG);
            } else if (script.outputType().isRational()) {
                builder.userValuetypeHint(ValueType.DOUBLE);
            } else if (DataTypes.isString((DataType)script.outputType())) {
                builder.userValuetypeHint(ValueType.STRING);
            } else if (script.outputType() == SqlDataTypes.DATE) {
                builder.userValuetypeHint(ValueType.LONG);
            } else if (script.outputType() == SqlDataTypes.TIME) {
                builder.userValuetypeHint(ValueType.LONG);
            } else if (script.outputType() == DataTypes.DATETIME) {
                builder.userValuetypeHint(ValueType.LONG);
            } else if (script.outputType() == DataTypes.BOOLEAN) {
                builder.userValuetypeHint(ValueType.BOOLEAN);
            } else if (script.outputType() == DataTypes.IP) {
                builder.userValuetypeHint(ValueType.IP);
            }
        } else {
            builder.field(this.source().fieldName());
        }
        return builder.order(this.direction.asOrder()).missingBucket(true);
    }

    protected abstract CompositeValuesSourceBuilder<?> createSourceBuilder();

    protected abstract GroupByKey copy(String var1, AggSource var2, Sort.Direction var3);

    public GroupByKey with(Sort.Direction direction) {
        return this.direction == direction ? this : this.copy(this.id(), this.source(), direction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.direction);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupByKey that = (GroupByKey)o;
        return this.direction == that.direction;
    }
}

