/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.enrich.GeoMatchProcessor;
import org.elasticsearch.xpack.enrich.MatchProcessor;

final class EnrichProcessorFactory
implements Processor.Factory,
Consumer<ClusterState> {
    static final String TYPE = "enrich";
    private final Client client;
    private final ScriptService scriptService;
    volatile Metadata metadata;

    EnrichProcessorFactory(Client client, ScriptService scriptService) {
        this.client = client;
        this.scriptService = scriptService;
    }

    public Processor create(Map<String, Processor.Factory> processorFactories, String tag, String description, Map<String, Object> config) throws Exception {
        String policyName = ConfigurationUtils.readStringProperty((String)TYPE, (String)tag, config, (String)"policy_name");
        String policyAlias = EnrichPolicy.getBaseName((String)policyName);
        if (this.metadata == null) {
            throw new IllegalStateException("enrich processor factory has not yet been initialized with cluster state");
        }
        IndexAbstraction indexAbstraction = (IndexAbstraction)this.metadata.getIndicesLookup().get(policyAlias);
        if (indexAbstraction == null) {
            throw new IllegalArgumentException("no enrich index exists for policy with name [" + policyName + "]");
        }
        assert (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS);
        assert (indexAbstraction.getIndices().size() == 1);
        IndexMetadata imd = (IndexMetadata)indexAbstraction.getIndices().get(0);
        Map mappingAsMap = imd.mapping().sourceAsMap();
        String policyType = (String)XContentMapValues.extractValue((String)"_meta.enrich_policy_type", (Map)mappingAsMap);
        String matchField = (String)XContentMapValues.extractValue((String)"_meta.enrich_match_field", (Map)mappingAsMap);
        TemplateScript.Factory field = ConfigurationUtils.readTemplateProperty((String)TYPE, (String)tag, config, (String)"field", (ScriptService)this.scriptService);
        boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)TYPE, (String)tag, config, (String)"ignore_missing", (boolean)false);
        boolean overrideEnabled = ConfigurationUtils.readBooleanProperty((String)TYPE, (String)tag, config, (String)"override", (boolean)true);
        TemplateScript.Factory targetField = ConfigurationUtils.readTemplateProperty((String)TYPE, (String)tag, config, (String)"target_field", (ScriptService)this.scriptService);
        int maxMatches = ConfigurationUtils.readIntProperty((String)TYPE, (String)tag, config, (String)"max_matches", (Integer)1);
        if (maxMatches < 1 || maxMatches > 128) {
            throw ConfigurationUtils.newConfigurationException((String)TYPE, (String)tag, (String)"max_matches", (String)"should be between 1 and 128");
        }
        switch (policyType) {
            case "match": {
                return new MatchProcessor(tag, description, this.client, policyName, field, targetField, overrideEnabled, ignoreMissing, matchField, maxMatches);
            }
            case "geo_match": {
                String relationStr = ConfigurationUtils.readStringProperty((String)TYPE, (String)tag, config, (String)"shape_relation", (String)"intersects");
                ShapeRelation shapeRelation = ShapeRelation.getRelationByName((String)relationStr);
                String orientationStr = ConfigurationUtils.readStringProperty((String)TYPE, (String)tag, config, (String)"orientation", (String)"CCW");
                Orientation orientation = Orientation.fromString((String)orientationStr);
                return new GeoMatchProcessor(tag, description, this.client, policyName, field, targetField, overrideEnabled, ignoreMissing, matchField, maxMatches, shapeRelation, orientation);
            }
        }
        throw new IllegalArgumentException("unsupported policy type [" + policyType + "]");
    }

    @Override
    public void accept(ClusterState state) {
        this.metadata = state.getMetadata();
    }
}

