/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack.watcher;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class PutWatchResponse
extends ActionResponse
implements ToXContentObject {
    private static final ObjectParser<PutWatchResponse, Void> PARSER = new ObjectParser("x_pack_put_watch_response", PutWatchResponse::new);
    private String id;
    private long version;
    private long seqNo = -2L;
    private long primaryTerm = 0L;
    private boolean created;

    public PutWatchResponse() {
    }

    public PutWatchResponse(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        this.version = in.readVLong();
        this.seqNo = in.readZLong();
        this.primaryTerm = in.readVLong();
        this.created = in.readBoolean();
    }

    public PutWatchResponse(String id, long version, long seqNo, long primaryTerm, boolean created) {
        this.id = id;
        this.version = version;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.created = created;
    }

    private void setId(String id) {
        this.id = id;
    }

    private void setVersion(long version) {
        this.version = version;
    }

    private void setSeqNo(long seqNo) {
        this.seqNo = seqNo;
    }

    private void setPrimaryTerm(long primaryTerm) {
        this.primaryTerm = primaryTerm;
    }

    private void setCreated(boolean created) {
        this.created = created;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public boolean isCreated() {
        return this.created;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PutWatchResponse that = (PutWatchResponse)((Object)o);
        return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version) && Objects.equals(this.seqNo, that.seqNo) && Objects.equals(this.primaryTerm, that.primaryTerm) && Objects.equals(this.created, that.created);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.seqNo, this.primaryTerm, this.created);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeVLong(this.version);
        out.writeZLong(this.seqNo);
        out.writeVLong(this.primaryTerm);
        out.writeBoolean(this.created);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("_id", this.id).field("_version", this.version).field("_seq_no", this.seqNo).field("_primary_term", this.primaryTerm).field("created", this.created).endObject();
    }

    public static PutWatchResponse fromXContent(XContentParser parser) throws IOException {
        return (PutWatchResponse)((Object)PARSER.parse(parser, null));
    }

    static {
        PARSER.declareString(PutWatchResponse::setId, new ParseField("_id", new String[0]));
        PARSER.declareLong(PutWatchResponse::setVersion, new ParseField("_version", new String[0]));
        PARSER.declareLong(PutWatchResponse::setSeqNo, new ParseField("_seq_no", new String[0]));
        PARSER.declareLong(PutWatchResponse::setPrimaryTerm, new ParseField("_primary_term", new String[0]));
        PARSER.declareBoolean(PutWatchResponse::setCreated, new ParseField("created", new String[0]));
    }
}

