/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.cluster.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;

public class MigrateToDataTiersRequest
extends AcknowledgedRequest<MigrateToDataTiersRequest> {
    private static final ParseField LEGACY_TEMPLATE_TO_DELETE = new ParseField("legacy_template_to_delete", new String[0]);
    private static final ParseField NODE_ATTRIBUTE_NAME = new ParseField("node_attribute", new String[0]);
    public static final ConstructingObjectParser<MigrateToDataTiersRequest, Void> PARSER = new ConstructingObjectParser("index_template", false, a -> new MigrateToDataTiersRequest((String)a[0], (String)a[1]));
    @Nullable
    private final String nodeAttributeName;
    @Nullable
    private final String legacyTemplateToDelete;
    private boolean dryRun = false;

    public static MigrateToDataTiersRequest parse(XContentParser parser) throws IOException {
        return (MigrateToDataTiersRequest)((Object)PARSER.parse(parser, null));
    }

    public MigrateToDataTiersRequest(@Nullable String legacyTemplateToDelete, @Nullable String nodeAttributeName) {
        this.legacyTemplateToDelete = legacyTemplateToDelete;
        this.nodeAttributeName = nodeAttributeName;
    }

    public MigrateToDataTiersRequest() {
        this(null, null);
    }

    public MigrateToDataTiersRequest(StreamInput in) throws IOException {
        super(in);
        this.dryRun = in.readBoolean();
        this.legacyTemplateToDelete = in.readOptionalString();
        this.nodeAttributeName = in.readOptionalString();
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.dryRun);
        out.writeOptionalString(this.legacyTemplateToDelete);
        out.writeOptionalString(this.nodeAttributeName);
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public String getNodeAttributeName() {
        return this.nodeAttributeName;
    }

    public String getLegacyTemplateToDelete() {
        return this.legacyTemplateToDelete;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MigrateToDataTiersRequest that = (MigrateToDataTiersRequest)((Object)o);
        return this.dryRun == that.dryRun && Objects.equals(this.nodeAttributeName, that.nodeAttributeName) && Objects.equals(this.legacyTemplateToDelete, that.legacyTemplateToDelete);
    }

    public int hashCode() {
        return Objects.hash(this.nodeAttributeName, this.legacyTemplateToDelete, this.dryRun);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), LEGACY_TEMPLATE_TO_DELETE);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), NODE_ATTRIBUTE_NAME);
    }
}

