/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class DataTiersFeatureSetUsage
extends XPackFeatureSet.Usage {
    private final Map<String, TierSpecificStats> tierStats;

    public DataTiersFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.tierStats = in.readMap(StreamInput::readString, TierSpecificStats::new);
    }

    public DataTiersFeatureSetUsage(Map<String, TierSpecificStats> tierStats) {
        super("data_tiers", true, true);
        this.tierStats = tierStats;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_7_10_0;
    }

    public Map<String, TierSpecificStats> getTierStats() {
        return Collections.unmodifiableMap(this.tierStats);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.tierStats, StreamOutput::writeString, (o, v) -> v.writeTo(o));
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        for (Map.Entry<String, TierSpecificStats> tierStats : this.tierStats.entrySet()) {
            builder.field(tierStats.getKey(), (ToXContent)tierStats.getValue());
        }
    }

    public int hashCode() {
        return Objects.hash(this.tierStats);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataTiersFeatureSetUsage other = (DataTiersFeatureSetUsage)obj;
        return Objects.equals(this.available, other.available) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.tierStats, other.tierStats);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static class TierSpecificStats
    implements Writeable,
    ToXContentObject {
        public final int nodeCount;
        public final int indexCount;
        public final int totalShardCount;
        public final int primaryShardCount;
        public final long docCount;
        public final long totalByteCount;
        public final long primaryByteCount;
        public final long primaryByteCountMedian;
        public final long primaryShardBytesMAD;

        public TierSpecificStats(StreamInput in) throws IOException {
            this.nodeCount = in.readVInt();
            this.indexCount = in.readVInt();
            this.totalShardCount = in.readVInt();
            this.primaryShardCount = in.readVInt();
            this.docCount = in.readVLong();
            this.totalByteCount = in.readVLong();
            this.primaryByteCount = in.readVLong();
            this.primaryByteCountMedian = in.readVLong();
            this.primaryShardBytesMAD = in.readVLong();
        }

        public TierSpecificStats(int nodeCount, int indexCount, int totalShardCount, int primaryShardCount, long docCount, long totalByteCount, long primaryByteCount, long primaryByteCountMedian, long primaryShardBytesMAD) {
            this.nodeCount = nodeCount;
            this.indexCount = indexCount;
            this.totalShardCount = totalShardCount;
            this.primaryShardCount = primaryShardCount;
            this.docCount = docCount;
            this.totalByteCount = totalByteCount;
            this.primaryByteCount = primaryByteCount;
            this.primaryByteCountMedian = primaryByteCountMedian;
            this.primaryShardBytesMAD = primaryShardBytesMAD;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.nodeCount);
            out.writeVInt(this.indexCount);
            out.writeVInt(this.totalShardCount);
            out.writeVInt(this.primaryShardCount);
            out.writeVLong(this.docCount);
            out.writeVLong(this.totalByteCount);
            out.writeVLong(this.primaryByteCount);
            out.writeVLong(this.primaryByteCountMedian);
            out.writeVLong(this.primaryShardBytesMAD);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("node_count", this.nodeCount);
            builder.field("index_count", this.indexCount);
            builder.field("total_shard_count", this.totalShardCount);
            builder.field("primary_shard_count", this.primaryShardCount);
            builder.field("doc_count", this.docCount);
            builder.humanReadableField("total_size_bytes", "total_size", (Object)new ByteSizeValue(this.totalByteCount));
            builder.humanReadableField("primary_size_bytes", "primary_size", (Object)new ByteSizeValue(this.primaryByteCount));
            builder.humanReadableField("primary_shard_size_avg_bytes", "primary_shard_size_avg", (Object)new ByteSizeValue(this.primaryShardCount == 0 ? 0L : this.primaryByteCount / (long)this.primaryShardCount));
            builder.humanReadableField("primary_shard_size_median_bytes", "primary_shard_size_median", (Object)new ByteSizeValue(this.primaryByteCountMedian));
            builder.humanReadableField("primary_shard_size_mad_bytes", "primary_shard_size_mad", (Object)new ByteSizeValue(this.primaryShardBytesMAD));
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.nodeCount, this.indexCount, this.totalShardCount, this.primaryShardCount, this.totalByteCount, this.primaryByteCount, this.docCount, this.primaryByteCountMedian, this.primaryShardBytesMAD);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TierSpecificStats other = (TierSpecificStats)obj;
            return this.nodeCount == other.nodeCount && this.indexCount == other.indexCount && this.totalShardCount == other.totalShardCount && this.primaryShardCount == other.primaryShardCount && this.docCount == other.docCount && this.totalByteCount == other.totalByteCount && this.primaryByteCount == other.primaryByteCount && this.primaryByteCountMedian == other.primaryByteCountMedian && this.primaryShardBytesMAD == other.primaryShardBytesMAD;
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

