/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.ingest.IngestStats;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceStats;

public class GetTrainedModelsStatsAction
extends ActionType<Response> {
    public static final GetTrainedModelsStatsAction INSTANCE = new GetTrainedModelsStatsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/inference/stats/get";
    public static final ParseField MODEL_ID = new ParseField("model_id", new String[0]);
    public static final ParseField PIPELINE_COUNT = new ParseField("pipeline_count", new String[0]);
    public static final ParseField INFERENCE_STATS = new ParseField("inference_stats", new String[0]);

    private GetTrainedModelsStatsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends AbstractGetResourcesResponse<TrainedModelStats> {
        public static final ParseField RESULTS_FIELD = new ParseField("trained_model_stats", new String[0]);

        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(QueryPage<TrainedModelStats> trainedModels) {
            super(trainedModels);
        }

        @Override
        protected Writeable.Reader<TrainedModelStats> getReader() {
            return TrainedModelStats::new;
        }

        public static class Builder {
            private long totalModelCount;
            private Map<String, Set<String>> expandedIdsWithAliases;
            private Map<String, IngestStats> ingestStatsMap;
            private Map<String, InferenceStats> inferenceStatsMap;

            public Builder setTotalModelCount(long totalModelCount) {
                this.totalModelCount = totalModelCount;
                return this;
            }

            public Builder setExpandedIdsWithAliases(Map<String, Set<String>> expandedIdsWithAliases) {
                this.expandedIdsWithAliases = expandedIdsWithAliases;
                return this;
            }

            public Map<String, Set<String>> getExpandedIdsWithAliases() {
                return this.expandedIdsWithAliases;
            }

            public Builder setIngestStatsByModelId(Map<String, IngestStats> ingestStatsByModelId) {
                this.ingestStatsMap = ingestStatsByModelId;
                return this;
            }

            public Builder setInferenceStatsByModelId(Map<String, InferenceStats> infereceStatsByModelId) {
                this.inferenceStatsMap = infereceStatsByModelId;
                return this;
            }

            public Response build() {
                ArrayList<TrainedModelStats> trainedModelStats = new ArrayList<TrainedModelStats>(this.expandedIdsWithAliases.size());
                this.expandedIdsWithAliases.keySet().forEach(id -> {
                    IngestStats ingestStats = this.ingestStatsMap.get(id);
                    InferenceStats inferenceStats = this.inferenceStatsMap.get(id);
                    trainedModelStats.add(new TrainedModelStats((String)id, ingestStats, ingestStats == null ? 0 : ingestStats.getPipelineStats().size(), inferenceStats));
                });
                trainedModelStats.sort(Comparator.comparing(TrainedModelStats::getModelId));
                return new Response(new QueryPage<TrainedModelStats>(trainedModelStats, this.totalModelCount, RESULTS_FIELD));
            }
        }

        public static class TrainedModelStats
        implements ToXContentObject,
        Writeable {
            private final String modelId;
            private final IngestStats ingestStats;
            private final InferenceStats inferenceStats;
            private final int pipelineCount;
            private static final IngestStats EMPTY_INGEST_STATS = new IngestStats(new IngestStats.Stats(0L, 0L, 0L, 0L), Collections.emptyList(), Collections.emptyMap());

            public TrainedModelStats(String modelId, IngestStats ingestStats, int pipelineCount, InferenceStats inferenceStats) {
                this.modelId = Objects.requireNonNull(modelId);
                IngestStats ingestStats2 = this.ingestStats = ingestStats == null ? EMPTY_INGEST_STATS : ingestStats;
                if (pipelineCount < 0) {
                    throw new ElasticsearchException("[{}] must be a greater than or equal to 0", new Object[]{PIPELINE_COUNT.getPreferredName()});
                }
                this.pipelineCount = pipelineCount;
                this.inferenceStats = inferenceStats;
            }

            public TrainedModelStats(StreamInput in) throws IOException {
                this.modelId = in.readString();
                this.ingestStats = new IngestStats(in);
                this.pipelineCount = in.readVInt();
                this.inferenceStats = in.getVersion().onOrAfter(Version.V_7_8_0) ? (InferenceStats)in.readOptionalWriteable(InferenceStats::new) : null;
            }

            public String getModelId() {
                return this.modelId;
            }

            public IngestStats getIngestStats() {
                return this.ingestStats;
            }

            public int getPipelineCount() {
                return this.pipelineCount;
            }

            public InferenceStats getInferenceStats() {
                return this.inferenceStats;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(MODEL_ID.getPreferredName(), this.modelId);
                builder.field(PIPELINE_COUNT.getPreferredName(), this.pipelineCount);
                if (this.pipelineCount > 0) {
                    this.ingestStats.toXContent(builder, params);
                }
                if (this.inferenceStats != null) {
                    builder.field(INFERENCE_STATS.getPreferredName(), (ToXContent)this.inferenceStats);
                }
                builder.endObject();
                return builder;
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.modelId);
                this.ingestStats.writeTo(out);
                out.writeVInt(this.pipelineCount);
                if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
                    out.writeOptionalWriteable((Writeable)this.inferenceStats);
                }
            }

            public int hashCode() {
                return Objects.hash(this.modelId, this.ingestStats, this.pipelineCount, this.inferenceStats);
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                TrainedModelStats other = (TrainedModelStats)obj;
                return Objects.equals(this.modelId, other.modelId) && Objects.equals(this.ingestStats, other.ingestStats) && Objects.equals(this.pipelineCount, other.pipelineCount) && Objects.equals(this.inferenceStats, other.inferenceStats);
            }
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        public RequestBuilder(ElasticsearchClient client, GetTrainedModelsStatsAction action) {
            super(client, (ActionType)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends AbstractGetResourcesRequest {
        public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);

        public Request() {
            this.setAllowNoResources(true);
        }

        public Request(String id) {
            this.setResourceId(id);
            this.setAllowNoResources(true);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public String getResourceIdField() {
            return TrainedModelConfig.MODEL_ID.getPreferredName();
        }
    }
}

