/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.ReservedFieldNames;
import org.elasticsearch.xpack.core.ml.job.results.Result;

public class CategoryDefinition
implements ToXContentObject,
Writeable {
    public static final ParseField TYPE = new ParseField("category_definition", new String[0]);
    public static final ParseField CATEGORY_ID = new ParseField("category_id", new String[0]);
    public static final ParseField PARTITION_FIELD_NAME = new ParseField("partition_field_name", new String[0]);
    public static final ParseField PARTITION_FIELD_VALUE = new ParseField("partition_field_value", new String[0]);
    public static final ParseField TERMS = new ParseField("terms", new String[0]);
    public static final ParseField REGEX = new ParseField("regex", new String[0]);
    public static final ParseField MAX_MATCHING_LENGTH = new ParseField("max_matching_length", new String[0]);
    public static final ParseField EXAMPLES = new ParseField("examples", new String[0]);
    public static final ParseField GROK_PATTERN = new ParseField("grok_pattern", new String[0]);
    public static final ParseField NUM_MATCHES = new ParseField("num_matches", new String[0]);
    public static final ParseField PREFERRED_TO_CATEGORIES = new ParseField("preferred_to_categories", new String[0]);
    public static final ParseField MLCATEGORY = new ParseField("mlcategory", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("categories", new String[0]);
    public static final ConstructingObjectParser<CategoryDefinition, Void> STRICT_PARSER = CategoryDefinition.createParser(false);
    public static final ConstructingObjectParser<CategoryDefinition, Void> LENIENT_PARSER = CategoryDefinition.createParser(true);
    private final String jobId;
    private long categoryId = 0L;
    private String partitionFieldName;
    private String partitionFieldValue;
    private String terms = "";
    private String regex = "";
    private long maxMatchingLength = 0L;
    private final Set<String> examples;
    private String grokPattern;
    private long[] preferredToCategories = new long[0];
    private long numMatches = 0L;

    private static ConstructingObjectParser<CategoryDefinition, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(TYPE.getPreferredName(), ignoreUnknownFields, a -> new CategoryDefinition((String)a[0]));
        parser.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        parser.declareLong(CategoryDefinition::setCategoryId, CATEGORY_ID);
        parser.declareString(CategoryDefinition::setPartitionFieldName, PARTITION_FIELD_NAME);
        parser.declareString(CategoryDefinition::setPartitionFieldValue, PARTITION_FIELD_VALUE);
        parser.declareString(CategoryDefinition::setTerms, TERMS);
        parser.declareString(CategoryDefinition::setRegex, REGEX);
        parser.declareLong(CategoryDefinition::setMaxMatchingLength, MAX_MATCHING_LENGTH);
        parser.declareStringArray(CategoryDefinition::setExamples, EXAMPLES);
        parser.declareString(CategoryDefinition::setGrokPattern, GROK_PATTERN);
        parser.declareLongArray(CategoryDefinition::setPreferredToCategories, PREFERRED_TO_CATEGORIES);
        parser.declareLong(CategoryDefinition::setNumMatches, NUM_MATCHES);
        parser.declareString((cd, rt) -> {}, Result.RESULT_TYPE);
        parser.declareString((cd, mc) -> {}, MLCATEGORY);
        return parser;
    }

    public CategoryDefinition(String jobId) {
        this.jobId = jobId;
        this.examples = new TreeSet<String>();
    }

    public CategoryDefinition(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.categoryId = in.readLong();
        if (in.getVersion().onOrAfter(Version.V_7_9_0)) {
            this.partitionFieldName = in.readOptionalString();
            this.partitionFieldValue = in.readOptionalString();
        }
        this.terms = in.readString();
        this.regex = in.readString();
        this.maxMatchingLength = in.readLong();
        this.examples = new TreeSet<String>(in.readStringList());
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            this.grokPattern = in.readOptionalString();
        }
        if (in.getVersion().onOrAfter(Version.V_7_8_0)) {
            this.preferredToCategories = in.readVLongArray();
            this.numMatches = in.readVLong();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeLong(this.categoryId);
        if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
            out.writeOptionalString(this.partitionFieldName);
            out.writeOptionalString(this.partitionFieldValue);
        }
        out.writeString(this.terms);
        out.writeString(this.regex);
        out.writeLong(this.maxMatchingLength);
        out.writeStringCollection(this.examples);
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeOptionalString(this.grokPattern);
        }
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            out.writeVLongArray(this.preferredToCategories);
            out.writeVLong(this.numMatches);
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getId() {
        return this.jobId + "_" + TYPE + "_" + this.categoryId;
    }

    public long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(long categoryId) {
        this.categoryId = categoryId;
    }

    public String getPartitionFieldName() {
        return this.partitionFieldName;
    }

    public void setPartitionFieldName(String partitionFieldName) {
        this.partitionFieldName = partitionFieldName;
    }

    public String getPartitionFieldValue() {
        return this.partitionFieldValue;
    }

    public void setPartitionFieldValue(String partitionFieldValue) {
        this.partitionFieldValue = partitionFieldValue;
    }

    public String getTerms() {
        return this.terms;
    }

    public void setTerms(String terms) {
        this.terms = terms;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public long getMaxMatchingLength() {
        return this.maxMatchingLength;
    }

    public void setMaxMatchingLength(long maxMatchingLength) {
        this.maxMatchingLength = maxMatchingLength;
    }

    public List<String> getExamples() {
        return new ArrayList<String>(this.examples);
    }

    public void setExamples(Collection<String> examples) {
        this.examples.clear();
        this.examples.addAll(examples);
    }

    public void addExample(String example) {
        this.examples.add(example);
    }

    public String getGrokPattern() {
        return this.grokPattern;
    }

    public void setGrokPattern(String grokPattern) {
        this.grokPattern = grokPattern;
    }

    public long[] getPreferredToCategories() {
        return this.preferredToCategories;
    }

    public void setPreferredToCategories(long[] preferredToCategories) {
        for (long category : preferredToCategories) {
            if (category >= 0L) continue;
            throw new IllegalArgumentException("[preferred_to_category] entries must be non-negative");
        }
        this.preferredToCategories = preferredToCategories;
    }

    private void setPreferredToCategories(List<Long> preferredToCategories) {
        this.setPreferredToCategories(preferredToCategories.stream().mapToLong(Long::longValue).toArray());
    }

    public long getNumMatches() {
        return this.numMatches;
    }

    public void setNumMatches(long numMatches) {
        if (numMatches < 0L) {
            throw new IllegalArgumentException("[num_matches] must be non-negative");
        }
        this.numMatches = numMatches;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(CATEGORY_ID.getPreferredName(), this.categoryId);
        if (this.partitionFieldName != null) {
            builder.field(PARTITION_FIELD_NAME.getPreferredName(), this.partitionFieldName);
        }
        if (this.partitionFieldValue != null) {
            builder.field(PARTITION_FIELD_VALUE.getPreferredName(), this.partitionFieldValue);
        }
        builder.field(TERMS.getPreferredName(), this.terms);
        builder.field(REGEX.getPreferredName(), this.regex);
        builder.field(MAX_MATCHING_LENGTH.getPreferredName(), this.maxMatchingLength);
        builder.field(EXAMPLES.getPreferredName(), this.examples);
        if (this.grokPattern != null) {
            builder.field(GROK_PATTERN.getPreferredName(), this.grokPattern);
        }
        if (this.preferredToCategories.length > 0) {
            builder.field(PREFERRED_TO_CATEGORIES.getPreferredName(), (Object)this.preferredToCategories);
        }
        if (this.numMatches > 0L) {
            builder.field(NUM_MATCHES.getPreferredName(), this.numMatches);
        }
        if (this.partitionFieldName != null && this.partitionFieldValue != null && ReservedFieldNames.isValidFieldName(this.partitionFieldName)) {
            builder.field(this.partitionFieldName, this.partitionFieldValue);
        }
        builder.field(Result.RESULT_TYPE.getPreferredName(), TYPE.getPreferredName());
        builder.field(MLCATEGORY.getPreferredName(), String.valueOf(this.categoryId));
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CategoryDefinition)) {
            return false;
        }
        CategoryDefinition that = (CategoryDefinition)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.categoryId, that.categoryId) && Objects.equals(this.partitionFieldName, that.partitionFieldName) && Objects.equals(this.partitionFieldValue, that.partitionFieldValue) && Objects.equals(this.terms, that.terms) && Objects.equals(this.regex, that.regex) && Objects.equals(this.maxMatchingLength, that.maxMatchingLength) && Objects.equals(this.examples, that.examples) && Objects.equals(this.grokPattern, that.grokPattern) && Arrays.equals(this.preferredToCategories, that.preferredToCategories) && Objects.equals(this.numMatches, that.numMatches);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.categoryId, this.partitionFieldName, this.partitionFieldValue, this.terms, this.regex, this.maxMatchingLength, this.examples, this.grokPattern, Arrays.hashCode(this.preferredToCategories), this.numMatches);
    }
}

