/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl.cert;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class CertificateInfo
implements ToXContentObject,
Writeable {
    private final String path;
    private final String format;
    private final String alias;
    private final String subjectDn;
    private final String serialNumber;
    private final boolean hasPrivateKey;
    private final ZonedDateTime expiry;

    public CertificateInfo(String path, String format, String alias, boolean hasPrivateKey, X509Certificate certificate) {
        Objects.requireNonNull(certificate, "Certificate cannot be null");
        this.path = Objects.requireNonNull(path, "Certificate path cannot be null");
        this.format = Objects.requireNonNull(format, "Certificate format cannot be null");
        this.alias = alias;
        this.subjectDn = Objects.requireNonNull(certificate.getSubjectDN().getName());
        this.serialNumber = certificate.getSerialNumber().toString(16);
        this.hasPrivateKey = hasPrivateKey;
        this.expiry = certificate.getNotAfter().toInstant().atZone(ZoneOffset.UTC);
    }

    public CertificateInfo(StreamInput in) throws IOException {
        this.path = in.readString();
        this.format = in.readString();
        this.alias = in.readOptionalString();
        this.subjectDn = in.readString();
        this.serialNumber = in.readString();
        this.hasPrivateKey = in.readBoolean();
        this.expiry = Instant.ofEpochMilli(in.readLong()).atZone(ZoneOffset.UTC);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.path);
        out.writeString(this.format);
        out.writeOptionalString(this.alias);
        out.writeString(this.subjectDn);
        out.writeString(this.serialNumber);
        out.writeBoolean(this.hasPrivateKey);
        out.writeLong(this.expiry.toInstant().toEpochMilli());
    }

    public String path() {
        return this.path;
    }

    public String format() {
        return this.format;
    }

    public String alias() {
        return this.alias;
    }

    public String subjectDn() {
        return this.subjectDn;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public ZonedDateTime expiry() {
        return this.expiry;
    }

    public boolean hasPrivateKey() {
        return this.hasPrivateKey;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("path", this.path).field("format", this.format).field("alias", this.alias).field("subject_dn", this.subjectDn).field("serial_number", this.serialNumber).field("has_private_key", this.hasPrivateKey).timeField("expiry", (Object)this.expiry).endObject();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CertificateInfo that = (CertificateInfo)other;
        return this.path.equals(that.path) && this.format.equals(that.format) && this.hasPrivateKey == that.hasPrivateKey && Objects.equals(this.alias, that.alias) && Objects.equals(this.serialNumber, that.serialNumber) && Objects.equals(this.subjectDn, that.subjectDn) && Objects.equals(this.expiry, that.expiry);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
        result = 31 * result + (this.serialNumber != null ? this.serialNumber.hashCode() : 0);
        return result;
    }
}

