/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.template;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.template.put.PutComponentTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleAction;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public abstract class IndexTemplateRegistry
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(IndexTemplateRegistry.class);
    protected final Settings settings;
    protected final Client client;
    protected final ThreadPool threadPool;
    protected final NamedXContentRegistry xContentRegistry;
    protected final ClusterService clusterService;
    protected final ConcurrentMap<String, AtomicBoolean> templateCreationsInProgress = new ConcurrentHashMap<String, AtomicBoolean>();
    protected final ConcurrentMap<String, AtomicBoolean> policyCreationsInProgress = new ConcurrentHashMap<String, AtomicBoolean>();

    public IndexTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        this.settings = nodeSettings;
        this.client = client;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
    }

    public void initialize() {
        this.clusterService.addListener((ClusterStateListener)this);
    }

    protected List<IndexTemplateConfig> getLegacyTemplateConfigs() {
        return Collections.emptyList();
    }

    protected List<IndexTemplateConfig> getComponentTemplateConfigs() {
        return Collections.emptyList();
    }

    protected List<IndexTemplateConfig> getComposableTemplateConfigs() {
        return Collections.emptyList();
    }

    protected List<LifecyclePolicyConfig> getPolicyConfigs() {
        return Collections.emptyList();
    }

    protected abstract String getOrigin();

    protected void onPutTemplateFailure(IndexTemplateConfig config, Exception e) {
        logger.error((Message)new ParameterizedMessage("error adding index template [{}] from [{}] for [{}]", new Object[]{config.getTemplateName(), config.getFileName(), this.getOrigin()}), (Throwable)e);
    }

    protected void onPutPolicyFailure(LifecyclePolicy policy, Exception e) {
        logger.error((Message)new ParameterizedMessage("error adding lifecycle policy [{}] for [{}]", (Object)policy.getName(), (Object)this.getOrigin()), (Throwable)e);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        DiscoveryNode masterNode = event.state().getNodes().getMasterNode();
        if (masterNode == null) {
            return;
        }
        if (this.requiresMasterNode() && !state.nodes().isLocalNodeElectedMaster()) {
            return;
        }
        DiscoveryNode localNode = event.state().getNodes().getLocalNode();
        boolean localNodeVersionAfterMaster = localNode.getVersion().after(masterNode.getVersion());
        if (event.localNodeMaster() || localNodeVersionAfterMaster) {
            this.addTemplatesIfMissing(state);
            this.addIndexLifecyclePoliciesIfMissing(state);
        }
    }

    protected boolean requiresMasterNode() {
        return false;
    }

    private void addTemplatesIfMissing(ClusterState state) {
        this.addLegacyTemplatesIfMissing(state);
        this.addComponentTemplatesIfMissing(state);
        this.addComposableTemplatesIfMissing(state);
    }

    private void addLegacyTemplatesIfMissing(ClusterState state) {
        List<IndexTemplateConfig> indexTemplates = this.getLegacyTemplateConfigs();
        for (IndexTemplateConfig newTemplate : indexTemplates) {
            String templateName = newTemplate.getTemplateName();
            AtomicBoolean creationCheck = this.templateCreationsInProgress.computeIfAbsent(templateName, key -> new AtomicBoolean(false));
            if (creationCheck.compareAndSet(false, true)) {
                IndexTemplateMetadata currentTemplate = (IndexTemplateMetadata)state.metadata().getTemplates().get((Object)templateName);
                if (Objects.isNull(currentTemplate)) {
                    logger.info("adding legacy template [{}] for [{}], because it doesn't exist", (Object)templateName, (Object)this.getOrigin());
                    this.putLegacyTemplate(newTemplate, creationCheck);
                    continue;
                }
                if (Objects.isNull(currentTemplate.getVersion()) || newTemplate.getVersion() > currentTemplate.getVersion()) {
                    logger.info("upgrading legacy template [{}] for [{}] from version [{}] to version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.getVersion(), (Object)newTemplate.getVersion());
                    this.putLegacyTemplate(newTemplate, creationCheck);
                    continue;
                }
                creationCheck.set(false);
                logger.trace("not adding legacy template [{}] for [{}], because it already exists at version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.getVersion());
                continue;
            }
            logger.trace("skipping the creation of legacy template [{}] for [{}], because its creation is in progress", (Object)templateName, (Object)this.getOrigin());
        }
    }

    private void addComponentTemplatesIfMissing(ClusterState state) {
        List<IndexTemplateConfig> indexTemplates = this.getComponentTemplateConfigs();
        for (IndexTemplateConfig newTemplate : indexTemplates) {
            String templateName = newTemplate.getTemplateName();
            AtomicBoolean creationCheck = this.templateCreationsInProgress.computeIfAbsent(templateName, key -> new AtomicBoolean(false));
            if (creationCheck.compareAndSet(false, true)) {
                ComponentTemplate currentTemplate = (ComponentTemplate)state.metadata().componentTemplates().get(templateName);
                if (Objects.isNull(currentTemplate)) {
                    logger.debug("adding component template [{}] for [{}], because it doesn't exist", (Object)templateName, (Object)this.getOrigin());
                    this.putComponentTemplate(newTemplate, creationCheck);
                    continue;
                }
                if (Objects.isNull(currentTemplate.version()) || (long)newTemplate.getVersion() > currentTemplate.version()) {
                    logger.info("upgrading component template [{}] for [{}] from version [{}] to version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.version(), (Object)newTemplate.getVersion());
                    this.putComponentTemplate(newTemplate, creationCheck);
                    continue;
                }
                creationCheck.set(false);
                logger.trace("not adding component template [{}] for [{}], because it already exists at version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.version());
                continue;
            }
            logger.trace("skipping the creation of component template [{}] for [{}], because its creation is in progress", (Object)templateName, (Object)this.getOrigin());
        }
    }

    private void addComposableTemplatesIfMissing(ClusterState state) {
        List<IndexTemplateConfig> indexTemplates = this.getComposableTemplateConfigs();
        for (IndexTemplateConfig newTemplate : indexTemplates) {
            String templateName = newTemplate.getTemplateName();
            AtomicBoolean creationCheck = this.templateCreationsInProgress.computeIfAbsent(templateName, key -> new AtomicBoolean(false));
            if (creationCheck.compareAndSet(false, true)) {
                ComposableIndexTemplate currentTemplate = (ComposableIndexTemplate)state.metadata().templatesV2().get(templateName);
                boolean componentTemplatesAvailable = IndexTemplateRegistry.componentTemplatesExist(state, newTemplate);
                if (!componentTemplatesAvailable) {
                    creationCheck.set(false);
                    logger.trace("not adding composable template [{}] for [{}] because its required component templates do not exist", (Object)templateName, (Object)this.getOrigin());
                    continue;
                }
                if (Objects.isNull(currentTemplate)) {
                    logger.debug("adding composable template [{}] for [{}], because it doesn't exist", (Object)templateName, (Object)this.getOrigin());
                    this.putComposableTemplate(newTemplate, creationCheck);
                    continue;
                }
                if (Objects.isNull(currentTemplate.version()) || (long)newTemplate.getVersion() > currentTemplate.version()) {
                    logger.info("upgrading composable template [{}] for [{}] from version [{}] to version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.version(), (Object)newTemplate.getVersion());
                    this.putComposableTemplate(newTemplate, creationCheck);
                    continue;
                }
                creationCheck.set(false);
                logger.trace("not adding composable template [{}] for [{}], because it already exists at version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.version());
                continue;
            }
            logger.trace("skipping the creation of composable template [{}] for [{}], because its creation is in progress", (Object)templateName, (Object)this.getOrigin());
        }
    }

    private static boolean componentTemplatesExist(ClusterState state, IndexTemplateConfig composableTemplate) {
        ComposableIndexTemplate indexTemplate;
        try {
            indexTemplate = ComposableIndexTemplate.parse((XContentParser)JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, composableTemplate.loadBytes()));
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("unable to parse composable template " + composableTemplate.getTemplateName(), (Throwable)e, new Object[0]);
        }
        HashSet neededComponents = new HashSet(indexTemplate.composedOf());
        return state.metadata().componentTemplates().keySet().containsAll(neededComponents);
    }

    private void putLegacyTemplate(final IndexTemplateConfig config, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            final String templateName = config.getTemplateName();
            PutIndexTemplateRequest request = new PutIndexTemplateRequest(templateName).source(config.loadBytes(), XContentType.JSON);
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.getOrigin(), request, new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        logger.error("error adding legacy template [{}] for [{}], request was not acknowledged", (Object)templateName, (Object)IndexTemplateRegistry.this.getOrigin());
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    IndexTemplateRegistry.this.onPutTemplateFailure(config, e);
                }
            }, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).putTemplate(arg_0, arg_1));
        });
    }

    private void putComponentTemplate(final IndexTemplateConfig config, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            final String templateName = config.getTemplateName();
            PutComponentTemplateAction.Request request = new PutComponentTemplateAction.Request(templateName);
            try {
                request.componentTemplate(ComponentTemplate.parse((XContentParser)JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, config.loadBytes())));
            }
            catch (Exception e) {
                throw new ElasticsearchParseException("unable to parse component template " + config.getTemplateName(), (Throwable)e, new Object[0]);
            }
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.getOrigin(), request, new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        logger.error("error adding component template [{}] for [{}], request was not acknowledged", (Object)templateName, (Object)IndexTemplateRegistry.this.getOrigin());
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    IndexTemplateRegistry.this.onPutTemplateFailure(config, e);
                }
            }, (req, listener) -> this.client.execute((ActionType)PutComponentTemplateAction.INSTANCE, (ActionRequest)req, listener));
        });
    }

    private void putComposableTemplate(final IndexTemplateConfig config, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            final String templateName = config.getTemplateName();
            PutComposableIndexTemplateAction.Request request = new PutComposableIndexTemplateAction.Request(templateName);
            try {
                request.indexTemplate(ComposableIndexTemplate.parse((XContentParser)JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, config.loadBytes())));
            }
            catch (Exception e) {
                throw new ElasticsearchParseException("unable to parse composable template " + config.getTemplateName(), (Throwable)e, new Object[0]);
            }
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.getOrigin(), request, new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        logger.error("error adding composable template [{}] for [{}], request was not acknowledged", (Object)templateName, (Object)IndexTemplateRegistry.this.getOrigin());
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    IndexTemplateRegistry.this.onPutTemplateFailure(config, e);
                }
            }, (req, listener) -> this.client.execute((ActionType)PutComposableIndexTemplateAction.INSTANCE, (ActionRequest)req, listener));
        });
    }

    private void addIndexLifecyclePoliciesIfMissing(ClusterState state) {
        Optional<IndexLifecycleMetadata> maybeMeta = Optional.ofNullable((IndexLifecycleMetadata)state.metadata().custom("index_lifecycle"));
        List policies = this.getPolicyConfigs().stream().map(policyConfig -> policyConfig.load(this.xContentRegistry)).collect(Collectors.toList());
        for (LifecyclePolicy policy : policies) {
            boolean policyNeedsToBeCreated;
            AtomicBoolean creationCheck = this.policyCreationsInProgress.computeIfAbsent(policy.getName(), key -> new AtomicBoolean(false));
            if (!creationCheck.compareAndSet(false, true)) continue;
            boolean bl = policyNeedsToBeCreated = !maybeMeta.flatMap(ilmMeta -> Optional.ofNullable(ilmMeta.getPolicies().get(policy.getName()))).isPresent();
            if (policyNeedsToBeCreated) {
                logger.debug("adding lifecycle policy [{}] for [{}], because it doesn't exist", (Object)policy.getName(), (Object)this.getOrigin());
                this.putPolicy(policy, creationCheck);
                continue;
            }
            logger.trace("not adding lifecycle policy [{}] for [{}], because it already exists", (Object)policy.getName(), (Object)this.getOrigin());
            creationCheck.set(false);
        }
    }

    private void putPolicy(final LifecyclePolicy policy, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            PutLifecycleAction.Request request = new PutLifecycleAction.Request(policy);
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.getOrigin(), request, new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        logger.error("error adding lifecycle policy [{}] for [{}], request was not acknowledged", (Object)policy.getName(), (Object)IndexTemplateRegistry.this.getOrigin());
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    IndexTemplateRegistry.this.onPutPolicyFailure(policy, e);
                }
            }, (req, listener) -> new XPackClient(this.client).ilmClient().putLifecyclePolicy((PutLifecycleAction.Request)((Object)((Object)req)), (ActionListener<AcknowledgedResponse>)listener));
        });
    }
}

