/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms.pivot;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xpack.core.transform.transforms.pivot.SingleGroupSource;

public class GeoTileGroupSource
extends SingleGroupSource {
    private static final String NAME = "transform_geo_tile_group";
    private static final ParseField PRECISION = new ParseField("precision", new String[0]);
    private static final ConstructingObjectParser<GeoTileGroupSource, Void> STRICT_PARSER = GeoTileGroupSource.createParser(false);
    private static final ConstructingObjectParser<GeoTileGroupSource, Void> LENIENT_PARSER = GeoTileGroupSource.createParser(true);
    private final Integer precision;
    private final GeoBoundingBox geoBoundingBox;

    private static ConstructingObjectParser<GeoTileGroupSource, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, lenient, args -> {
            String field = (String)args[0];
            boolean missingBucket = args[1] == null ? false : (Boolean)args[1];
            Integer precision = (Integer)args[2];
            GeoBoundingBox boundingBox = (GeoBoundingBox)args[3];
            return new GeoTileGroupSource(field, missingBucket, precision, boundingBox);
        });
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), FIELD);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), MISSING_BUCKET);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), PRECISION);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, context) -> GeoBoundingBox.parseBoundingBox((XContentParser)p), GeoBoundingBox.BOUNDS_FIELD, ObjectParser.ValueType.OBJECT);
        return parser;
    }

    public GeoTileGroupSource(String field, boolean missingBucket, Integer precision, GeoBoundingBox boundingBox) {
        super(field, null, missingBucket);
        if (precision != null) {
            GeoTileUtils.checkPrecisionRange((int)precision);
        }
        this.precision = precision;
        this.geoBoundingBox = boundingBox;
    }

    public GeoTileGroupSource(StreamInput in) throws IOException {
        super(in);
        this.precision = in.readOptionalVInt();
        this.geoBoundingBox = (GeoBoundingBox)in.readOptionalWriteable(GeoBoundingBox::new);
    }

    @Override
    public SingleGroupSource.Type getType() {
        return SingleGroupSource.Type.GEOTILE_GRID;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalVInt(this.precision);
        out.writeOptionalWriteable((Writeable)this.geoBoundingBox);
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public GeoBoundingBox getGeoBoundingBox() {
        return this.geoBoundingBox;
    }

    public static GeoTileGroupSource fromXContent(XContentParser parser, boolean lenient) {
        return lenient ? (GeoTileGroupSource)LENIENT_PARSER.apply(parser, null) : (GeoTileGroupSource)STRICT_PARSER.apply(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        super.innerXContent(builder, params);
        if (this.precision != null) {
            builder.field(PRECISION.getPreferredName(), this.precision);
        }
        if (this.geoBoundingBox != null) {
            builder.startObject(GeoBoundingBox.BOUNDS_FIELD.getPreferredName());
            this.geoBoundingBox.toXContentFragment(builder, true);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GeoTileGroupSource that = (GeoTileGroupSource)other;
        return this.missingBucket == that.missingBucket && Objects.equals(this.field, that.field) && Objects.equals(this.precision, that.precision) && Objects.equals(this.geoBoundingBox, that.geoBoundingBox);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.missingBucket, this.precision, this.geoBoundingBox);
    }

    @Override
    public String getMappingType() {
        return "geo_shape";
    }
}

