/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.capacity;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class AutoscalingCapacity
implements ToXContent,
Writeable {
    private final AutoscalingResources total;
    private final AutoscalingResources node;
    public static final AutoscalingCapacity ZERO = new AutoscalingCapacity(AutoscalingResources.ZERO, AutoscalingResources.ZERO);

    public AutoscalingCapacity(AutoscalingResources total, AutoscalingResources node) {
        assert (total != null) : "Cannot provide capacity without specifying total capacity";
        assert (node == null || node.memory == null || total.memory != null) : "Cannot provide node memory without total memory";
        assert (node == null || node.storage == null || total.storage != null) : "Cannot provide node storage without total memory";
        this.total = total;
        this.node = node;
    }

    public AutoscalingCapacity(StreamInput in) throws IOException {
        this.total = new AutoscalingResources(in);
        this.node = (AutoscalingResources)in.readOptionalWriteable(AutoscalingResources::new);
    }

    public AutoscalingResources total() {
        return this.total;
    }

    public AutoscalingResources node() {
        return this.node;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.total.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.node);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.node != null) {
            builder.field("node", (ToXContent)this.node);
        }
        builder.field("total", (ToXContent)this.total);
        builder.endObject();
        return builder;
    }

    public boolean isFragment() {
        return false;
    }

    public static AutoscalingCapacity upperBound(AutoscalingCapacity c1, AutoscalingCapacity c2) {
        return new AutoscalingCapacity(AutoscalingResources.max(c1.total, c2.total), AutoscalingResources.max(c1.node, c2.node));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoscalingCapacity capacity = (AutoscalingCapacity)o;
        return this.total.equals(capacity.total) && Objects.equals(this.node, capacity.node);
    }

    public int hashCode() {
        return Objects.hash(this.total, this.node);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class AutoscalingResources
    implements ToXContent,
    Writeable {
        private final ByteSizeValue storage;
        private final ByteSizeValue memory;
        public static final AutoscalingResources ZERO = new AutoscalingResources(new ByteSizeValue(0L), new ByteSizeValue(0L));

        public AutoscalingResources(ByteSizeValue storage, ByteSizeValue memory) {
            assert (storage != null || memory != null);
            this.storage = storage;
            this.memory = memory;
        }

        public AutoscalingResources(StreamInput in) throws IOException {
            this.storage = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.memory = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
        }

        public ByteSizeValue storage() {
            return this.storage;
        }

        public ByteSizeValue memory() {
            return this.memory;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.storage != null) {
                builder.field("storage", this.storage.getBytes());
            }
            if (this.memory != null) {
                builder.field("memory", this.memory.getBytes());
            }
            builder.endObject();
            return builder;
        }

        public boolean isFragment() {
            return false;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable((Writeable)this.storage);
            out.writeOptionalWriteable((Writeable)this.memory);
        }

        public static AutoscalingResources max(AutoscalingResources sm1, AutoscalingResources sm2) {
            if (sm1 == null) {
                return sm2;
            }
            if (sm2 == null) {
                return sm1;
            }
            return new AutoscalingResources(AutoscalingResources.max(sm1.storage, sm2.storage), AutoscalingResources.max(sm1.memory, sm2.memory));
        }

        public static AutoscalingResources sum(AutoscalingResources sm1, AutoscalingResources sm2) {
            if (sm1 == null) {
                return sm2;
            }
            if (sm2 == null) {
                return sm1;
            }
            return new AutoscalingResources(AutoscalingResources.add(sm1.storage, sm2.storage), AutoscalingResources.add(sm1.memory, sm2.memory));
        }

        private static ByteSizeValue max(ByteSizeValue v1, ByteSizeValue v2) {
            if (v1 == null) {
                return v2;
            }
            if (v2 == null) {
                return v1;
            }
            return v1.compareTo(v2) < 0 ? v2 : v1;
        }

        private static ByteSizeValue add(ByteSizeValue v1, ByteSizeValue v2) {
            if (v1 == null) {
                return v2;
            }
            if (v2 == null) {
                return v1;
            }
            return new ByteSizeValue(v1.getBytes() + v2.getBytes());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AutoscalingResources that = (AutoscalingResources)o;
            return Objects.equals(this.storage, that.storage) && Objects.equals(this.memory, that.memory);
        }

        public int hashCode() {
            return Objects.hash(this.storage, this.memory);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class Builder {
        private AutoscalingResources total;
        private AutoscalingResources node;

        public Builder capacity(AutoscalingCapacity capacity) {
            this.total = capacity.total;
            this.node = capacity.node;
            return this;
        }

        public Builder total(Long storage, Long memory) {
            return this.total(this.byteSizeValue(storage), this.byteSizeValue(memory));
        }

        public Builder total(ByteSizeValue storage, ByteSizeValue memory) {
            return this.total(new AutoscalingResources(storage, memory));
        }

        public Builder total(AutoscalingResources total) {
            this.total = total;
            return this;
        }

        public Builder node(Long storage, Long memory) {
            return this.node(this.byteSizeValue(storage), this.byteSizeValue(memory));
        }

        public Builder node(ByteSizeValue storage, ByteSizeValue memory) {
            return this.node(new AutoscalingResources(storage, memory));
        }

        public Builder node(AutoscalingResources node) {
            this.node = node;
            return this;
        }

        public AutoscalingCapacity build() {
            return new AutoscalingCapacity(this.total, this.node);
        }

        private ByteSizeValue byteSizeValue(Long memory) {
            return memory == null ? null : new ByteSizeValue(memory.longValue());
        }
    }
}

