/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.shards;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCapacity;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderContext;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResult;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderService;
import org.elasticsearch.xpack.autoscaling.util.FrozenUtils;

public class FrozenShardsDeciderService
implements AutoscalingDeciderService {
    public static final String NAME = "frozen_shards";
    private static final ByteSizeValue MAX_MEMORY = ByteSizeValue.ofGb((long)64L);
    static final ByteSizeValue DEFAULT_MEMORY_PER_SHARD = ByteSizeValue.ofBytes((long)(MAX_MEMORY.getBytes() / 2000L));
    public static final Setting<ByteSizeValue> MEMORY_PER_SHARD = Setting.byteSizeSetting((String)"memory_per_shard", ignored -> DEFAULT_MEMORY_PER_SHARD.getStringRep(), (ByteSizeValue)ByteSizeValue.ZERO, (ByteSizeValue)ByteSizeValue.ofBytes((long)Long.MAX_VALUE), (Setting.Property[])new Setting.Property[0]);

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public AutoscalingDeciderResult scale(Settings configuration, AutoscalingDeciderContext context) {
        int shards = FrozenShardsDeciderService.countFrozenShards(context.state().metadata());
        long memory = (long)shards * ((ByteSizeValue)MEMORY_PER_SHARD.get(configuration)).getBytes();
        return new AutoscalingDeciderResult(AutoscalingCapacity.builder().total(null, memory).build(), new FrozenShardsReason(shards));
    }

    static int countFrozenShards(Metadata metadata) {
        return StreamSupport.stream(metadata.spliterator(), false).filter(imd -> FrozenUtils.isFrozenIndex(imd.getSettings())).mapToInt(IndexMetadata::getTotalNumberOfShards).sum();
    }

    @Override
    public List<Setting<?>> deciderSettings() {
        return org.elasticsearch.core.List.of(MEMORY_PER_SHARD);
    }

    @Override
    public List<DiscoveryNodeRole> roles() {
        return org.elasticsearch.core.List.of((Object)DiscoveryNodeRole.DATA_FROZEN_NODE_ROLE);
    }

    public static class FrozenShardsReason
    implements AutoscalingDeciderResult.Reason {
        private final long shards;

        public FrozenShardsReason(long shards) {
            assert (shards >= 0L);
            this.shards = shards;
        }

        public FrozenShardsReason(StreamInput in) throws IOException {
            this.shards = in.readVLong();
        }

        @Override
        public String summary() {
            return "shard count [" + this.shards + "]";
        }

        public long shards() {
            return this.shards;
        }

        public String getWriteableName() {
            return FrozenShardsDeciderService.NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.shards);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("shards", this.shards);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FrozenShardsReason that = (FrozenShardsReason)o;
            return this.shards == that.shards;
        }

        public int hashCode() {
            return Objects.hash(this.shards);
        }
    }
}

