/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.webhook;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.watcher.common.http.HttpRequest;
import org.elasticsearch.xpack.watcher.common.http.HttpRequestTemplate;
import org.elasticsearch.xpack.watcher.common.http.HttpResponse;

public class WebhookAction
implements Action {
    public static final String TYPE = "webhook";
    final HttpRequestTemplate requestTemplate;

    public WebhookAction(HttpRequestTemplate requestTemplate) {
        this.requestTemplate = requestTemplate;
    }

    public String type() {
        return TYPE;
    }

    public HttpRequestTemplate getRequest() {
        return this.requestTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookAction action = (WebhookAction)o;
        return this.requestTemplate.equals(action.requestTemplate);
    }

    public int hashCode() {
        return this.requestTemplate.hashCode();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.requestTemplate.toXContent(builder, params);
    }

    public static WebhookAction parse(String watchId, String actionId, XContentParser parser) throws IOException {
        try {
            HttpRequestTemplate request = HttpRequestTemplate.Parser.parse(parser);
            return new WebhookAction(request);
        }
        catch (ElasticsearchParseException pe) {
            throw new ElasticsearchParseException("could not parse [{}] action [{}/{}]. failed parsing http request template", (Throwable)pe, new Object[]{TYPE, watchId, actionId});
        }
    }

    public static Builder builder(HttpRequestTemplate requestTemplate) {
        return new Builder(requestTemplate);
    }

    public static class Builder
    implements Action.Builder<WebhookAction> {
        final HttpRequestTemplate requestTemplate;

        private Builder(HttpRequestTemplate requestTemplate) {
            this.requestTemplate = requestTemplate;
        }

        public WebhookAction build() {
            return new WebhookAction(this.requestTemplate);
        }
    }

    static interface Field {
        public static final ParseField REQUEST = new ParseField("request", new String[0]);
        public static final ParseField RESPONSE = new ParseField("response", new String[0]);
    }

    public static interface Result {

        public static class Simulated
        extends Action.Result
        implements Result {
            private final HttpRequest request;

            public Simulated(HttpRequest request) {
                super(WebhookAction.TYPE, Action.Result.Status.SIMULATED);
                this.request = request;
            }

            public HttpRequest request() {
                return this.request;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.startObject(this.type).field(Field.REQUEST.getPreferredName(), (ToXContent)this.request, params).endObject();
            }
        }

        public static class Failure
        extends Action.Result.Failure
        implements Result {
            private final HttpRequest request;
            private final HttpResponse response;

            public Failure(HttpRequest request, HttpResponse response) {
                this(request, response, "received [{}] status code", response.status());
            }

            private Failure(HttpRequest request, HttpResponse response, String reason, Object ... args) {
                super(WebhookAction.TYPE, reason, args);
                this.request = request;
                this.response = response;
            }

            public HttpResponse response() {
                return this.response;
            }

            public HttpRequest request() {
                return this.request;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                super.toXContent(builder, params);
                return builder.startObject(this.type).field(Field.REQUEST.getPreferredName(), (ToXContent)this.request, params).field(Field.RESPONSE.getPreferredName(), (ToXContent)this.response, params).endObject();
            }
        }

        public static class Success
        extends Action.Result
        implements Result {
            private final HttpRequest request;
            private final HttpResponse response;

            public Success(HttpRequest request, HttpResponse response) {
                super(WebhookAction.TYPE, Action.Result.Status.SUCCESS);
                this.request = request;
                this.response = response;
            }

            public HttpResponse response() {
                return this.response;
            }

            public HttpRequest request() {
                return this.request;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.startObject(this.type).field(Field.REQUEST.getPreferredName(), (ToXContent)this.request, params).field(Field.RESPONSE.getPreferredName(), (ToXContent)this.response, params).endObject();
            }
        }
    }
}

