/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.chain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.core.watcher.input.Input;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.input.InputRegistry;

public class ChainInput
implements Input {
    public static final String TYPE = "chain";
    public static final ParseField INPUTS = new ParseField("inputs", new String[0]);
    private final List<Tuple<String, Input>> inputs;

    public ChainInput(List<Tuple<String, Input>> inputs) {
        this.inputs = inputs;
    }

    public String type() {
        return TYPE;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(INPUTS.getPreferredName());
        for (Tuple<String, Input> tuple : this.inputs) {
            builder.startObject().startObject((String)tuple.v1());
            builder.field(((Input)tuple.v2()).type(), (ToXContent)tuple.v2(), params);
            builder.endObject().endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public List<Tuple<String, Input>> getInputs() {
        return this.inputs;
    }

    public static ChainInput parse(String watchId, XContentParser parser, InputRegistry inputRegistry) throws IOException {
        XContentParser.Token token;
        ArrayList<Tuple<String, Input>> inputs = new ArrayList<Tuple<String, Input>>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if (token != XContentParser.Token.START_ARRAY || !INPUTS.getPreferredName().equals(currentFieldName)) continue;
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token != XContentParser.Token.FIELD_NAME) continue;
                String inputName = parser.currentName();
                inputs.add((Tuple<String, Input>)new Tuple((Object)inputName, (Object)ChainInput.parseSingleInput(watchId, inputName, parser, inputRegistry)));
            }
        }
        return new ChainInput(inputs);
    }

    private static Input parseSingleInput(String watchId, String name, XContentParser parser, InputRegistry inputRegistry) throws IOException {
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("Expected starting JSON object after [{}] in watch [{}]", new Object[]{name, watchId});
        }
        Input input = inputRegistry.parse(watchId, parser).input();
        if (parser.currentToken() != XContentParser.Token.END_OBJECT || parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("Expected closing JSON object after parsing input [{}] named [{}] in watch [{}]", new Object[]{input.type(), name, watchId});
        }
        return input;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements Input.Builder<ChainInput> {
        private List<Tuple<String, Input>> inputs = new ArrayList<Tuple<String, Input>>();

        private Builder() {
        }

        public Builder add(String name, Input.Builder<?> input) {
            this.inputs.add((Tuple<String, Input>)new Tuple((Object)name, (Object)input.build()));
            return this;
        }

        public ChainInput build() {
            return new ChainInput(this.inputs);
        }
    }

    public static class Result
    extends Input.Result {
        private List<Tuple<String, Input.Result>> results = Collections.emptyList();

        protected Result(List<Tuple<String, Input.Result>> results, Payload payload) {
            super(ChainInput.TYPE, payload);
            this.results = results;
        }

        protected Result(Exception e) {
            super(ChainInput.TYPE, e);
        }

        protected XContentBuilder typeXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.type);
            for (Tuple<String, Input.Result> tuple : this.results) {
                builder.field((String)tuple.v1(), (ToXContent)tuple.v2());
            }
            builder.endObject();
            return builder;
        }
    }
}

