/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.chain;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.core.watcher.input.Input;
import org.elasticsearch.xpack.watcher.input.InputFactory;
import org.elasticsearch.xpack.watcher.input.InputRegistry;
import org.elasticsearch.xpack.watcher.input.chain.ChainInput;
import org.elasticsearch.xpack.watcher.input.chain.ExecutableChainInput;

public class ChainInputFactory
extends InputFactory<ChainInput, ChainInput.Result, ExecutableChainInput> {
    private final InputRegistry inputRegistry;

    public ChainInputFactory(InputRegistry inputRegistry) {
        this.inputRegistry = inputRegistry;
    }

    @Override
    public String type() {
        return "chain";
    }

    @Override
    public ChainInput parseInput(String watchId, XContentParser parser) throws IOException {
        return ChainInput.parse(watchId, parser, this.inputRegistry);
    }

    @Override
    public ExecutableChainInput createExecutable(ChainInput input) {
        ArrayList executableInputs = new ArrayList();
        for (Tuple<String, Input> tuple : input.getInputs()) {
            Object executableInput = this.inputRegistry.factories().get(((Input)tuple.v2()).type()).createExecutable((Input)tuple.v2());
            executableInputs.add(new Tuple((Object)((String)tuple.v1()), executableInput));
        }
        return new ExecutableChainInput(input, executableInputs);
    }
}

