/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DeleteSamlServiceProviderRequest
extends ActionRequest {
    private final String entityId;
    private final WriteRequest.RefreshPolicy refreshPolicy;

    public DeleteSamlServiceProviderRequest(String entityId, WriteRequest.RefreshPolicy refreshPolicy) {
        this.entityId = entityId;
        this.refreshPolicy = Objects.requireNonNull(refreshPolicy, "Refresh policy may not be null");
    }

    public DeleteSamlServiceProviderRequest(StreamInput in) throws IOException {
        this.entityId = in.readString();
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom((StreamInput)in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.entityId);
        this.refreshPolicy.writeTo(out);
    }

    public String getEntityId() {
        return this.entityId;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty((String)this.entityId)) {
            validationException = ValidateActions.addValidationError((String)"The Service Provider Entity ID is required", validationException);
        }
        return validationException;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DeleteSamlServiceProviderRequest that = (DeleteSamlServiceProviderRequest)((Object)o);
        return Objects.equals(this.entityId, that.entityId);
    }

    public int hashCode() {
        return Objects.hash(this.entityId, this.refreshPolicy);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{" + this.entityId + "," + this.refreshPolicy + "}";
    }
}

