/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.shutdown.PutShutdownNodeAction;

public class TransportPutShutdownNodeAction
extends AcknowledgedTransportMasterNodeAction<PutShutdownNodeAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportPutShutdownNodeAction.class);

    @Inject
    public TransportPutShutdownNodeAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/shutdown/create", transportService, clusterService, threadPool, actionFilters, PutShutdownNodeAction.Request::new, indexNameExpressionResolver, "same");
    }

    protected void masterOperation(final PutShutdownNodeAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.clusterService.submitStateUpdateTask("put-node-shutdown-" + request.getNodeId(), (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                SingleNodeShutdownMetadata existingRecord;
                NodesShutdownMetadata currentShutdownMetadata = (NodesShutdownMetadata)currentState.metadata().custom("node_shutdown");
                if (currentShutdownMetadata == null) {
                    currentShutdownMetadata = new NodesShutdownMetadata(new HashMap());
                }
                if ((existingRecord = (SingleNodeShutdownMetadata)currentShutdownMetadata.getAllNodeMetadataMap().get(request.getNodeId())) != null) {
                    logger.info("updating existing shutdown record for node [{}] of type [{}] with reason [{}] with new type [{}] and reason [{}]", (Object)existingRecord.getNodeId(), (Object)existingRecord.getType(), (Object)existingRecord.getReason(), (Object)request.getType(), (Object)request.getReason());
                }
                boolean nodeSeen = currentState.getNodes().nodeExists(request.getNodeId());
                SingleNodeShutdownMetadata newNodeMetadata = SingleNodeShutdownMetadata.builder().setNodeId(request.getNodeId()).setType(request.getType()).setReason(request.getReason()).setStartedAtMillis(System.currentTimeMillis()).setNodeSeen(nodeSeen).setAllocationDelay(request.getAllocationDelay()).build();
                return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentState.metadata()).putCustom("node_shutdown", (Metadata.Custom)currentShutdownMetadata.putSingleNodeMetadata(newNodeMetadata))).build();
            }

            public void onFailure(String source, Exception e) {
                logger.error((Message)new ParameterizedMessage("failed to put shutdown for node [{}]", (Object)request.getNodeId()), (Throwable)e);
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (SingleNodeShutdownMetadata.Type.REMOVE.equals((Object)request.getType())) {
                    TransportPutShutdownNodeAction.this.clusterService.getRerouteService().reroute("node registered for removal from cluster", Priority.NORMAL, (ActionListener)new ActionListener<ClusterState>(){

                        public void onResponse(ClusterState clusterState) {
                            logger.trace("started reroute after registering node [{}] for removal", (Object)request.getNodeId());
                            listener.onResponse((Object)AcknowledgedResponse.TRUE);
                        }

                        public void onFailure(Exception e) {
                            logger.warn((Message)new ParameterizedMessage("failed to start reroute after registering node [{}] for removal", (Object)request.getNodeId()), (Throwable)e);
                            listener.onFailure(e);
                        }
                    });
                } else {
                    logger.trace("not starting reroute after registering node [" + request.getNodeId() + "] for shutdown of type [" + request.getType() + "]");
                    listener.onResponse((Object)AcknowledgedResponse.TRUE);
                }
            }
        });
    }

    protected ClusterBlockException checkBlock(PutShutdownNodeAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

