/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.List;
import org.elasticsearch.core.Nullable;

public interface IndexAbstraction {
    public Type getType();

    public String getName();

    public java.util.List<IndexMetadata> getIndices();

    @Nullable
    public IndexMetadata getWriteIndex();

    @Nullable
    public DataStream getParentDataStream();

    public boolean isHidden();

    public boolean isSystem();

    default public boolean isDataStreamRelated() {
        return false;
    }

    public static class DataStream
    implements IndexAbstraction {
        private final org.elasticsearch.cluster.metadata.DataStream dataStream;
        private final java.util.List<IndexMetadata> dataStreamIndices;
        private final IndexMetadata writeIndex;

        public DataStream(org.elasticsearch.cluster.metadata.DataStream dataStream, java.util.List<IndexMetadata> dataStreamIndices) {
            this.dataStream = dataStream;
            this.dataStreamIndices = List.copyOf(dataStreamIndices);
            this.writeIndex = dataStreamIndices.get(dataStreamIndices.size() - 1);
        }

        @Override
        public String getName() {
            return this.dataStream.getName();
        }

        @Override
        public Type getType() {
            return Type.DATA_STREAM;
        }

        @Override
        public java.util.List<IndexMetadata> getIndices() {
            return this.dataStreamIndices;
        }

        @Override
        public IndexMetadata getWriteIndex() {
            return this.writeIndex;
        }

        @Override
        public DataStream getParentDataStream() {
            return null;
        }

        @Override
        public boolean isHidden() {
            return this.dataStream.isHidden();
        }

        @Override
        public boolean isSystem() {
            return this.dataStream.isSystem();
        }

        @Override
        public boolean isDataStreamRelated() {
            return true;
        }

        public org.elasticsearch.cluster.metadata.DataStream getDataStream() {
            return this.dataStream;
        }
    }

    public static class Alias
    implements IndexAbstraction {
        private final String aliasName;
        private final java.util.List<IndexMetadata> referenceIndexMetadatas;
        private final IndexMetadata writeIndex;
        private final boolean isHidden;
        private final boolean dataStreamAlias;

        public Alias(AliasMetadata aliasMetadata, java.util.List<IndexMetadata> indices) {
            this.aliasName = aliasMetadata.getAlias();
            this.referenceIndexMetadatas = indices;
            java.util.List writeIndices = indices.stream().filter(idxMeta -> Boolean.TRUE.equals(idxMeta.getAliases().get(this.aliasName).writeIndex())).collect(Collectors.toList());
            if (writeIndices.isEmpty() && this.referenceIndexMetadatas.size() == 1 && this.referenceIndexMetadatas.get(0).getAliases().get(this.aliasName).writeIndex() == null) {
                writeIndices.add(this.referenceIndexMetadatas.get(0));
            }
            if (writeIndices.size() == 0) {
                this.writeIndex = null;
            } else if (writeIndices.size() == 1) {
                this.writeIndex = (IndexMetadata)writeIndices.get(0);
            } else {
                java.util.List writeIndicesStrings = writeIndices.stream().map(i -> i.getIndex().getName()).collect(Collectors.toList());
                throw new IllegalStateException("alias [" + this.aliasName + "] has more than one write index [" + Strings.collectionToCommaDelimitedString(writeIndicesStrings) + "]");
            }
            this.isHidden = aliasMetadata.isHidden() == null ? false : aliasMetadata.isHidden();
            this.dataStreamAlias = false;
            this.validateAliasProperties();
        }

        public Alias(DataStreamAlias dataStreamAlias, java.util.List<IndexMetadata> indicesOfAllDataStreams, IndexMetadata writeIndexOfWriteDataStream) {
            this.aliasName = dataStreamAlias.getName();
            this.referenceIndexMetadatas = indicesOfAllDataStreams;
            this.writeIndex = writeIndexOfWriteDataStream;
            this.isHidden = false;
            this.dataStreamAlias = true;
        }

        @Override
        public Type getType() {
            return Type.ALIAS;
        }

        @Override
        public String getName() {
            return this.aliasName;
        }

        @Override
        public java.util.List<IndexMetadata> getIndices() {
            return this.referenceIndexMetadatas;
        }

        @Override
        @Nullable
        public IndexMetadata getWriteIndex() {
            return this.writeIndex;
        }

        @Override
        public DataStream getParentDataStream() {
            return null;
        }

        @Override
        public boolean isHidden() {
            return this.isHidden;
        }

        @Override
        public boolean isSystem() {
            return this.referenceIndexMetadatas.stream().allMatch(IndexMetadata::isSystem);
        }

        @Override
        public boolean isDataStreamRelated() {
            return this.dataStreamAlias;
        }

        private void validateAliasProperties() {
            Map<Boolean, java.util.List<IndexMetadata>> groupedByHiddenStatus = this.referenceIndexMetadatas.stream().collect(Collectors.groupingBy(idxMeta -> Boolean.TRUE.equals(idxMeta.getAliases().get(this.aliasName).isHidden())));
            if (this.isNonEmpty(groupedByHiddenStatus.get(true)) && this.isNonEmpty(groupedByHiddenStatus.get(false))) {
                java.util.List hiddenOn = groupedByHiddenStatus.get(true).stream().map(idx -> idx.getIndex().getName()).collect(Collectors.toList());
                java.util.List nonHiddenOn = groupedByHiddenStatus.get(false).stream().map(idx -> idx.getIndex().getName()).collect(Collectors.toList());
                throw new IllegalStateException("alias [" + this.aliasName + "] has is_hidden set to true on indices [" + Strings.collectionToCommaDelimitedString(hiddenOn) + "] but does not have is_hidden set to true on indices [" + Strings.collectionToCommaDelimitedString(nonHiddenOn) + "]; alias must have the same is_hidden setting on all indices");
            }
        }

        private boolean isNonEmpty(java.util.List<IndexMetadata> idxMetas) {
            return !(Objects.isNull(idxMetas) || idxMetas.isEmpty());
        }
    }

    public static class Index
    implements IndexAbstraction {
        private final IndexMetadata concreteIndex;
        private final DataStream dataStream;

        public Index(IndexMetadata indexMetadata, DataStream dataStream) {
            this.concreteIndex = indexMetadata;
            this.dataStream = dataStream;
        }

        public Index(IndexMetadata indexMetadata) {
            this(indexMetadata, null);
        }

        @Override
        public String getName() {
            return this.concreteIndex.getIndex().getName();
        }

        @Override
        public Type getType() {
            return Type.CONCRETE_INDEX;
        }

        @Override
        public java.util.List<IndexMetadata> getIndices() {
            return Collections.singletonList(this.concreteIndex);
        }

        @Override
        public IndexMetadata getWriteIndex() {
            return this.concreteIndex;
        }

        @Override
        public DataStream getParentDataStream() {
            return this.dataStream;
        }

        @Override
        public boolean isHidden() {
            return IndexMetadata.INDEX_HIDDEN_SETTING.get(this.concreteIndex.getSettings());
        }

        @Override
        public boolean isSystem() {
            return this.concreteIndex.isSystem();
        }
    }

    public static enum Type {
        CONCRETE_INDEX("concrete index"),
        ALIAS("alias"),
        DATA_STREAM("data_stream");

        private final String displayName;

        private Type(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

