/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.metrics;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.elasticsearch.Assertions;

public final class CounterMetric {
    private final LongAdder counter = new LongAdder();
    private final AtomicLong assertingCounter = Assertions.ENABLED ? new AtomicLong() : null;

    private boolean assertNonNegative(long n) {
        assert (n >= 0L) : "CounterMetric value must always be non-negative; got: " + n;
        return true;
    }

    public void inc() {
        this.counter.increment();
        assert (this.assertNonNegative(this.assertingCounter.incrementAndGet()));
    }

    public void inc(long n) {
        this.counter.add(n);
        assert (this.assertNonNegative(this.assertingCounter.addAndGet(n)));
    }

    public void dec() {
        this.counter.decrement();
        assert (this.assertNonNegative(this.assertingCounter.decrementAndGet()));
    }

    public void dec(long n) {
        this.counter.add(-n);
        assert (this.assertNonNegative(this.assertingCounter.addAndGet(-n)));
    }

    public long count() {
        for (int i = 0; i < 5; ++i) {
            long count = this.counter.sum();
            if (count < 0L) continue;
            return count;
        }
        return 0L;
    }
}

