/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.gateway.CorruptStateException;
import org.elasticsearch.gateway.MetadataStateFormat;

public final class ShardStateMetadata {
    private static final String SHARD_STATE_FILE_PREFIX = "state-";
    private static final String PRIMARY_KEY = "primary";
    private static final String INDEX_UUID_KEY = "index_uuid";
    private static final String ALLOCATION_ID_KEY = "allocation_id";
    public final String indexUUID;
    public final boolean primary;
    @Nullable
    public final AllocationId allocationId;
    public static final MetadataStateFormat<ShardStateMetadata> FORMAT = new MetadataStateFormat<ShardStateMetadata>("state-"){

        @Override
        protected XContentBuilder newXContentBuilder(XContentType type, OutputStream stream) throws IOException {
            XContentBuilder xContentBuilder = super.newXContentBuilder(type, stream);
            xContentBuilder.prettyPrint();
            return xContentBuilder;
        }

        @Override
        public void toXContent(XContentBuilder builder, ShardStateMetadata shardStateMetadata) throws IOException {
            builder.field(ShardStateMetadata.PRIMARY_KEY, shardStateMetadata.primary);
            builder.field(ShardStateMetadata.INDEX_UUID_KEY, shardStateMetadata.indexUUID);
            if (shardStateMetadata.allocationId != null) {
                builder.field(ShardStateMetadata.ALLOCATION_ID_KEY, (ToXContent)shardStateMetadata.allocationId);
            }
        }

        @Override
        public ShardStateMetadata fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                return null;
            }
            Boolean primary = null;
            String currentFieldName = null;
            String indexUUID = "_na_";
            AllocationId allocationId = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (ShardStateMetadata.PRIMARY_KEY.equals(currentFieldName)) {
                        primary = parser.booleanValue();
                        continue;
                    }
                    if (ShardStateMetadata.INDEX_UUID_KEY.equals(currentFieldName)) {
                        indexUUID = parser.text();
                        continue;
                    }
                    throw new CorruptStateException("unexpected field in shard state [" + currentFieldName + "]");
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (ShardStateMetadata.ALLOCATION_ID_KEY.equals(currentFieldName)) {
                        allocationId = AllocationId.fromXContent(parser);
                        continue;
                    }
                    throw new CorruptStateException("unexpected object in shard state [" + currentFieldName + "]");
                }
                throw new CorruptStateException("unexpected token in shard state [" + token.name() + "]");
            }
            if (primary == null) {
                throw new CorruptStateException("missing value for [primary] in shard state");
            }
            return new ShardStateMetadata(primary, indexUUID, allocationId);
        }
    };

    public ShardStateMetadata(boolean primary, String indexUUID, AllocationId allocationId) {
        assert (indexUUID != null);
        this.primary = primary;
        this.indexUUID = indexUUID;
        this.allocationId = allocationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardStateMetadata that = (ShardStateMetadata)o;
        if (this.primary != that.primary) {
            return false;
        }
        if (!this.indexUUID.equals(that.indexUUID)) {
            return false;
        }
        return Objects.equals(this.allocationId, that.allocationId);
    }

    public int hashCode() {
        int result = this.indexUUID.hashCode();
        result = 31 * result + (this.allocationId != null ? this.allocationId.hashCode() : 0);
        result = 31 * result + (this.primary ? 1 : 0);
        return result;
    }

    public String toString() {
        return "primary [" + this.primary + "], allocation [" + this.allocationId + "]";
    }
}

