/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.MissingValues;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public enum CoreValuesSourceType implements ValuesSourceType
{
    NUMERIC{

        @Override
        public ValuesSource getEmpty() {
            return ValuesSource.Numeric.EMPTY;
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return new ValuesSource.Numeric.Script(script, scriptValueType);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script, AggregationContext context) {
            if (!(fieldContext.indexFieldData() instanceof IndexNumericFieldData)) {
                throw new IllegalArgumentException("Expected numeric type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
            }
            ValuesSource.Numeric dataSource = new ValuesSource.Numeric.FieldData((IndexNumericFieldData)fieldContext.indexFieldData());
            if (script != null) {
                dataSource = new ValuesSource.Numeric.WithScript(dataSource, script);
            }
            return dataSource;
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            Number missing = rawMissing instanceof Number ? (Number)((Number)rawMissing) : (Number)docValueFormat.parseDouble(rawMissing.toString(), false, context::nowInMillis);
            return MissingValues.replaceMissing((ValuesSource.Numeric)valuesSource, missing);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }
    }
    ,
    KEYWORD{

        @Override
        public ValuesSource getEmpty() {
            return ValuesSource.Bytes.WithOrdinals.EMPTY;
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return new ValuesSource.Bytes.Script(script);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script, AggregationContext context) {
            IndexFieldData<?> indexFieldData = fieldContext.indexFieldData();
            ValuesSource.Bytes dataSource = indexFieldData instanceof IndexOrdinalsFieldData ? new ValuesSource.Bytes.WithOrdinals.FieldData((IndexOrdinalsFieldData)indexFieldData) : new ValuesSource.Bytes.FieldData(indexFieldData);
            if (script != null) {
                dataSource = new ValuesSource.Bytes.WithScript(dataSource, script);
            }
            return dataSource;
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            BytesRef missing = docValueFormat.parseBytesRef(rawMissing.toString());
            if (valuesSource instanceof ValuesSource.Bytes.WithOrdinals) {
                return MissingValues.replaceMissing((ValuesSource.Bytes.WithOrdinals)valuesSource, missing);
            }
            return MissingValues.replaceMissing((ValuesSource.Bytes)valuesSource, missing);
        }
    }
    ,
    GEOPOINT{

        @Override
        public ValuesSource getEmpty() {
            return ValuesSource.GeoPoint.EMPTY;
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            throw new AggregationExecutionException("value source of type [" + this.value() + "] is not supported by scripts");
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script, AggregationContext context) {
            if (!(fieldContext.indexFieldData() instanceof IndexGeoPointFieldData)) {
                throw new IllegalArgumentException("Expected geo_point type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
            }
            return new ValuesSource.GeoPoint.Fielddata((IndexGeoPointFieldData)fieldContext.indexFieldData());
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            GeoPoint missing = new GeoPoint(rawMissing.toString());
            return MissingValues.replaceMissing((ValuesSource.GeoPoint)valuesSource, missing);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return DocValueFormat.GEOHASH;
        }
    }
    ,
    RANGE{

        @Override
        public ValuesSource getEmpty() {
            throw new IllegalArgumentException("Can't deal with unmapped ValuesSource type " + this.value());
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            throw new AggregationExecutionException("value source of type [" + this.value() + "] is not supported by scripts");
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script, AggregationContext context) {
            MappedFieldType fieldType = fieldContext.fieldType();
            if (!(fieldType instanceof RangeFieldMapper.RangeFieldType)) {
                throw new IllegalStateException("Asked for range ValuesSource, but field is of type " + fieldType.name());
            }
            RangeFieldMapper.RangeFieldType rangeFieldType = (RangeFieldMapper.RangeFieldType)fieldType;
            return new ValuesSource.Range(fieldContext.indexFieldData(), rangeFieldType.rangeType());
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            throw new IllegalArgumentException("Can't apply missing values on a " + valuesSource.getClass());
        }
    }
    ,
    IP{

        @Override
        public ValuesSource getEmpty() {
            return KEYWORD.getEmpty();
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return KEYWORD.getScript(script, scriptValueType);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script, AggregationContext context) {
            return KEYWORD.getField(fieldContext, script, context);
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            return KEYWORD.replaceMissing(valuesSource, rawMissing, docValueFormat, context);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return DocValueFormat.IP;
        }
    }
    ,
    DATE{

        @Override
        public ValuesSource getEmpty() {
            return NUMERIC.getEmpty();
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return NUMERIC.getScript(script, scriptValueType);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script, AggregationContext context) {
            ValuesSource.Numeric dataSource = this.fieldData(fieldContext, context);
            if (script != null) {
                return new ValuesSource.Numeric.WithScript(dataSource, script);
            }
            return dataSource;
        }

        private ValuesSource.Numeric fieldData(final FieldContext fieldContext, final AggregationContext context) {
            if (!(fieldContext.indexFieldData() instanceof IndexNumericFieldData)) {
                throw new IllegalArgumentException("Expected numeric type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
            }
            if (!(fieldContext.fieldType() instanceof DateFieldMapper.DateFieldType)) {
                return new ValuesSource.Numeric.FieldData((IndexNumericFieldData)fieldContext.indexFieldData());
            }
            return new ValuesSource.Numeric.FieldData((IndexNumericFieldData)fieldContext.indexFieldData()){

                @Override
                public Function<Rounding, Rounding.Prepared> roundingPreparer() throws IOException {
                    byte[] min;
                    final DateFieldMapper.DateFieldType dft = (DateFieldMapper.DateFieldType)fieldContext.fieldType();
                    final long[] range = new long[]{Long.MIN_VALUE, Long.MAX_VALUE};
                    if (fieldContext.fieldType().isSearchable() && (min = PointValues.getMinPackedValue((IndexReader)context.searcher().getIndexReader(), (String)fieldContext.field())) != null) {
                        byte[] max = PointValues.getMaxPackedValue((IndexReader)context.searcher().getIndexReader(), (String)fieldContext.field());
                        range[0] = dft.resolution().parsePointAsMillis(min);
                        range[1] = dft.resolution().parsePointAsMillis(max);
                    }
                    if (context.query() != null) {
                        context.query().visit(new QueryVisitor(){

                            public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
                                if (occur != BooleanClause.Occur.MUST) {
                                    return QueryVisitor.EMPTY_VISITOR;
                                }
                                return this;
                            }

                            public boolean acceptField(String field) {
                                return field.equals(fieldContext.fieldType().name());
                            }

                            public void visitLeaf(Query query) {
                                if (query instanceof PointRangeQuery) {
                                    PointRangeQuery prq = (PointRangeQuery)query;
                                    range[0] = Math.max(range[0], dft.resolution().parsePointAsMillis(prq.getLowerPoint()));
                                    range[1] = Math.min(range[1], dft.resolution().parsePointAsMillis(prq.getUpperPoint()));
                                }
                            }
                        });
                    }
                    if (range[0] == Long.MIN_VALUE && range[1] == Long.MAX_VALUE) {
                        return Rounding::prepareForUnknown;
                    }
                    return rounding -> rounding.prepare(range[0], range[1]);
                }
            };
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            return NUMERIC.replaceMissing(valuesSource, rawMissing, docValueFormat, context);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return new DocValueFormat.DateTime(format == null ? DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER : DateFormatter.forPattern(format), tz == null ? ZoneOffset.UTC : tz, DateFieldMapper.Resolution.MILLISECONDS);
        }
    }
    ,
    BOOLEAN{

        @Override
        public ValuesSource getEmpty() {
            return NUMERIC.getEmpty();
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return NUMERIC.getScript(script, scriptValueType);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script, AggregationContext context) {
            return NUMERIC.getField(fieldContext, script, context);
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            return NUMERIC.replaceMissing(valuesSource, rawMissing, docValueFormat, context);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return DocValueFormat.BOOLEAN;
        }
    };

    public static List<ValuesSourceType> ALL_CORE;

    public static ValuesSourceType fromString(String name) {
        return CoreValuesSourceType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public String value() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public String typeName() {
        return this.value();
    }

    static {
        ALL_CORE = Arrays.asList(CoreValuesSourceType.values());
    }
}

