/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.AbstractObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceFieldConfig;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public final class MultiValuesSourceParseHelper {
    public static <T> void declareCommon(AbstractObjectParser<? extends MultiValuesSourceAggregationBuilder<?>, T> objectParser, boolean formattable, ValueType expectedValueType) {
        objectParser.declareField(MultiValuesSourceAggregationBuilder::userValueTypeHint, p -> {
            ValueType valueType = ValueType.lenientParse(p.text());
            if (expectedValueType != null && valueType.isNotA(expectedValueType)) {
                throw new ParsingException(p.getTokenLocation(), "Aggregation [" + objectParser.getName() + "] was configured with an incompatible value type [" + valueType + "].  It can only work on value off type [" + expectedValueType + "]", new Object[0]);
            }
            return valueType;
        }, ValueType.VALUE_TYPE, ObjectParser.ValueType.STRING);
        if (formattable) {
            objectParser.declareField(MultiValuesSourceAggregationBuilder::format, XContentParser::text, ParseField.CommonFields.FORMAT, ObjectParser.ValueType.STRING);
        }
    }

    public static <VS extends ValuesSource, T> void declareField(String fieldName, AbstractObjectParser<? extends MultiValuesSourceAggregationBuilder<?>, T> objectParser, boolean scriptable, boolean timezoneAware, boolean filterable, boolean heterogeneous) {
        objectParser.declareField((o, fieldConfig) -> o.field(fieldName, fieldConfig.build()), (p, c) -> (MultiValuesSourceFieldConfig.Builder)MultiValuesSourceFieldConfig.PARSER.build(scriptable, timezoneAware, filterable, heterogeneous).parse(p, null), new ParseField(fieldName, new String[0]), ObjectParser.ValueType.OBJECT);
    }
}

