/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.index.fieldvisitor.SingleFieldsVisitor;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.TypeFieldMapper;
import org.elasticsearch.search.lookup.FieldLookup;

public class LeafStoredFieldsLookup
implements Map<Object, FieldLookup> {
    private final Function<String, MappedFieldType> fieldTypeLookup;
    private final CheckedBiConsumer<Integer, StoredFieldVisitor, IOException> reader;
    private int docId = -1;
    private final Map<String, FieldLookup> cachedFieldData = new HashMap<String, FieldLookup>();

    LeafStoredFieldsLookup(Function<String, MappedFieldType> fieldTypeLookup, CheckedBiConsumer<Integer, StoredFieldVisitor, IOException> reader) {
        this.fieldTypeLookup = fieldTypeLookup;
        this.reader = reader;
    }

    public void setDocument(int docId) {
        if (this.docId == docId) {
            return;
        }
        this.docId = docId;
        this.clearCache();
    }

    @Override
    public FieldLookup get(Object key) {
        return this.loadFieldData(key.toString());
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            this.loadFieldData(key.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldLookup put(Object key, FieldLookup value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldLookup remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    private FieldLookup loadFieldData(String name) {
        MappedFieldType fieldType;
        FieldLookup data = this.cachedFieldData.get(name);
        if (data == null) {
            fieldType = this.fieldTypeLookup.apply(name);
            if (fieldType == null) {
                throw new IllegalArgumentException("No field found for [" + name + "] in mapping");
            }
            data = new FieldLookup(fieldType);
            this.cachedFieldData.put(name, data);
        }
        if (data.fields() == null) {
            ArrayList<Object> values;
            fieldType = data.fieldType();
            if ("_type".equals(fieldType.name())) {
                TypeFieldMapper.emitTypesDeprecationWarning();
                values = Collections.singletonList(((TypeFieldMapper.TypeFieldType)fieldType).getType());
            } else {
                values = new ArrayList(2);
                SingleFieldsVisitor visitor = new SingleFieldsVisitor(fieldType, values);
                try {
                    this.reader.accept(this.docId, visitor);
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to load field [{}]", (Throwable)e, name);
                }
            }
            data.fields(Collections.singletonMap(fieldType.name(), values));
        }
        return data;
    }

    private void clearCache() {
        if (this.cachedFieldData.isEmpty()) {
            return;
        }
        for (Map.Entry<String, FieldLookup> entry : this.cachedFieldData.entrySet()) {
            entry.getValue().clear();
        }
    }
}

