/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.core.List;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.histogram.DoubleBounds;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregatorSupplier;
import org.elasticsearch.search.aggregations.bucket.histogram.NumericHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.RangeHistogramAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public final class HistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final HistogramAggregatorSupplier aggregatorSupplier;
    private final double interval;
    private final double offset;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final DoubleBounds extendedBounds;
    private final DoubleBounds hardBounds;

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(HistogramAggregationBuilder.REGISTRY_KEY, CoreValuesSourceType.RANGE, RangeHistogramAggregator::new, true);
        builder.register(HistogramAggregationBuilder.REGISTRY_KEY, List.of((Object[])new ValuesSourceType[]{CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN}), NumericHistogramAggregator::new, true);
    }

    public HistogramAggregatorFactory(String name, ValuesSourceConfig config, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, DoubleBounds extendedBounds, DoubleBounds hardBounds, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, HistogramAggregatorSupplier aggregatorSupplier) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.aggregatorSupplier = aggregatorSupplier;
        this.interval = interval;
        this.offset = offset;
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.hardBounds = hardBounds;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    @Override
    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.aggregatorSupplier.build(this.name, this.factories, this.interval, this.offset, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.hardBounds, this.config, this.context, parent, cardinality, metadata);
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new NumericHistogramAggregator(this.name, this.factories, this.interval, this.offset, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.hardBounds, this.config, this.context, parent, CardinalityUpperBound.NONE, metadata);
    }
}

