/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation.logging;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.logging.RateLimitingFilter;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.deprecation.logging.DeprecationIndexingAppender;
import org.elasticsearch.xpack.deprecation.logging.EcsJsonLayout;

public class DeprecationIndexingComponent
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(DeprecationIndexingComponent.class);
    public static final Setting<Boolean> WRITE_DEPRECATION_LOGS_TO_INDEX = Setting.boolSetting((String)"cluster.deprecation_indexing.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final DeprecationIndexingAppender appender;
    private final BulkProcessor processor;
    private final RateLimitingFilter filter;

    public DeprecationIndexingComponent(Client client, Settings settings) {
        this.processor = this.getBulkProcessor((Client)new OriginSettingClient(client, "deprecation"), settings);
        Consumer<IndexRequest> consumer = arg_0 -> ((BulkProcessor)this.processor).add(arg_0);
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = context.getConfiguration();
        EcsJsonLayout ecsLayout = ((EcsJsonLayout.Builder)((EcsJsonLayout.Builder)((Object)((EcsJsonLayout.Builder)((Object)EcsJsonLayout.newBuilder())).setDataset("deprecation.elasticsearch"))).setESMessageFields("category,key,x-opaque-id").setConfiguration(configuration)).build();
        this.filter = new RateLimitingFilter();
        this.appender = new DeprecationIndexingAppender("deprecation_indexing_appender", (Filter)this.filter, (Layout<String>)ecsLayout, consumer);
    }

    protected void doStart() {
        this.appender.start();
        Loggers.addAppender((Logger)LogManager.getLogger((String)"org.elasticsearch.deprecation"), (Appender)this.appender);
    }

    protected void doStop() {
        Loggers.removeAppender((Logger)LogManager.getLogger((String)"org.elasticsearch.deprecation"), (Appender)this.appender);
        this.appender.stop();
    }

    protected void doClose() {
        this.processor.close();
    }

    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        boolean newEnabled = (Boolean)WRITE_DEPRECATION_LOGS_TO_INDEX.get(state.getMetadata().settings());
        if (this.appender.isEnabled() != newEnabled) {
            if (newEnabled) {
                this.filter.reset();
            }
            this.appender.setEnabled(newEnabled);
        }
    }

    private BulkProcessor getBulkProcessor(Client client, Settings settings) {
        DeprecationBulkListener listener = new DeprecationBulkListener();
        return BulkProcessor.builder((arg_0, arg_1) -> ((Client)client).bulk(arg_0, arg_1), (BulkProcessor.Listener)listener, (String)"deprecation-indexing").setBackoffPolicy(BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)1000L), (int)3)).setConcurrentRequests(Math.max(2, EsExecutors.allocatedProcessors((Settings)settings))).setBulkActions(-1).setBulkSize(new ByteSizeValue(-1L, ByteSizeUnit.BYTES)).setFlushInterval(TimeValue.timeValueSeconds((long)5L)).build();
    }

    private static class DeprecationBulkListener
    implements BulkProcessor.Listener {
        private DeprecationBulkListener() {
        }

        public void beforeBulk(long executionId, BulkRequest request) {
        }

        public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
            long numberOfActions = request.numberOfActions();
            if (logger.isTraceEnabled()) {
                logger.trace("indexed [{}] deprecation documents into [{}]", (Object)numberOfActions, (Object)Arrays.stream(response.getItems()).map(BulkItemResponse::getIndex).distinct().collect(Collectors.joining(",")));
            }
            if (response.hasFailures()) {
                Map<String, String> failures = Arrays.stream(response.getItems()).filter(BulkItemResponse::isFailed).collect(Collectors.toMap(BulkItemResponse::getId, BulkItemResponse::getFailureMessage));
                logger.error("Bulk write of deprecation logs encountered some failures: [{}]", failures);
            }
        }

        public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
            logger.error("Bulk write of " + request.numberOfActions() + " deprecation logs failed: " + failure.getMessage(), failure);
        }
    }
}

